﻿(function ($) {
    var action = 0;
    var formID = "#form-user-contactGroup";
    var dataForm;
    var backToGrid = 0; /*Navigation user if 1 hide section and show gridview; if 0 navigate user to respective address book */
    var disabledClick = true;
    var accordionId = "#accordion";
    var firstLoadGrid = false;
    var $contactTree, $contactTreeMobile;
    var contactTreeCall = false;

    var contactGroupValidation = function () {
		$(formID).validate({
			ignore: [],
            ignoreTitle: true,
            rules: {
                GroupName: {
                    required: true,
                    noSpace: true
				},
				"NewContactDropDownList.ContactAddrBookList.Value": {
					required: true
				},
                recipient_printer: {
                    required: true
				},
				"TotalGrid-gridContactGroupDetails": {
					required: true,
					min: 1
				}
			},
			messages: {
				"TotalGrid-gridContactGroupDetails": {
					required: $globalMessages.validation.gridMinLength,
					min: $globalMessages.validation.gridMinLength
				}
			},
            submitHandler: function (form) {
                $.contactGroup.save(action);
			}
        });
    };

    $.contactGroup = {
        init: function (e) {

            contactGroupValidation();

            /*Create New Contact Group */
            $('.btn-save').click(function (e) {
                action = 0;
                backToGrid = 0;
                $('#ContactGroupId').val(0);
                $(formID).submit();
            });
            /* End */

            /* Update Entry Page*/
            $('.btn-save-new5').click(function (e) {
                action = 0;
                $('#ContactGroupId').val(0);
                $(formID).submit();
            });

            $('.btn-save5').click(function (e) {
                action = 1;
                backToGrid = 1;
                $(formID).submit();
            });
            /* End */

            /* Reset Btn */
            $.contactGroup.resetButtonClickHandler();
            /* End */

            /*Init Contact List*/
            $.contactGroupDetail.init();

            /*Search Action Handler*/
            $.contactGroup.searchPressEnter($('#contactGroupDetailSearch'));
            $.contactGroup.searchButtonClickHandler($('#contactGroupDetailSearchButton'));
			$.contactGroup.resetFields();

        },

        /*Btn Action*/
        createButtonClickHandler: function (e, isAddrBook = false) {
            $(e).on('click', function (x) {
				dataForm = null;
				$.sectionproperties.FifthLevel();
                $.contactGroup.resetFields(dataForm);
                $('#form-user-contactGroup').validate().resetForm();
                $("#collapseOne").collapse('show');
                disabledClick = true;
            });

        },
        editHandler: function (dataItem) {
            $.sectionproperties.FifthLevel();
            $.contactGroup.getForm(dataItem.Id);
        },
        resetButtonClickHandler: function (e) {
			$('.btn-Reset, .btn-Reset5, .btn-reset-contactGroup').on('click', function (x) {
                $.contactGroup.resetFields(dataForm);
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.contactGroup.search();
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.contactGroup.search();
                }
            });
        },

        /* Logic */
        search: function (e) {
            var filter = { logic: "or", filters: [] };
            $searchValue = $.trim($('#contactGroupDetailSearch').val());
            $(gridId).data("kendoGrid").dataSource.filter({
                logic: "or",
                filters: [
                    {
                        field: "DisplayName",
                        operator: "contains",
                        value: $searchValue
                    },
                    {
                        field: "CompanyName",
                        operator: "contains",
                        value: $searchValue
                    },
                    {
                        field: "DisplayAddress",
                        operator: "contains",
                        value: $searchValue
                    }
                ]
            });
        },
		resetFields: function (data) {
            data = data || null;
            backToGrid = 1;

            $(formID).trigger("reset");
            $(formID).validate().resetForm();

            $.sectionproperties.HideField(".btn-save5", true);

            $('#ContactGroupId').val('0');
            $(".btn-save-new5").text("Save");
			$(".title5").text($areaResources.actionTitle.createNewContactGroup);
            if ($('input#addressBookId').length > 0) {
                if ($('#ContactAddrBookId option').filter(function () { return $(this).val() == $('input#addressBookId').val(); }).length) {
                    /*found*/
                    $("#ContactAddrBookId").val($('input#addressBookId').val()).change();
                }
            }

            if (data !== null) {

                backToGrid = 0;
                disabledClick = false;

                $.sectionproperties.HideField(".btn-save5", false);

                $(".title5").text($areaResources.actionTitle.updateContactGroup);
                $(".btn-save-new5").text($globalMessages.button.saveAsNew);

                $('#ContactGroupId').val(data.Id);
                $(".infoContactGroup").text(data.GroupName);
                $('#GroupName').val(data.GroupName);
                $('#DescriptionGroup').val(data.Description);
                $('#ContactAddrBookId').val(data.AddressBookId);
                /* Visibility - 3 (Global) not available in user panel */
                $('#ContactVisibilityId').val($("#ContactVisibilityId option[value='" + data.Visibility + "']").length > 0 ? data.Visibility : $("#ContactVisibilityId option:first").val());
				$.contactGroupDetail.initGrid(false);
			}
			else if ($grid)
			{
				kendogridcustomization.customizeGridHeight($("#gridContactGroupDetails"), true);
				$grid.data('kendoGrid').dataSource.data([]);
				$grid.data("kendoGrid").refresh();
			}
        },

        /*Post or Get Function*/
        save: function (action) {

			var listData = [];

			var grid = $(gridId).data("kendoGrid");

			if (grid !== undefined) {
				var data = grid.dataSource.data();
				var totalNumber = data.length;
				for (var i = 0; i < totalNumber; i++) {
					listData.push(
						{
							DisplayName: data[i]['DisplayName'],
							CompanyName: data[i]['CompanyName'],
							DisplayAddress: data[i]['DisplayAddress'],
							IsRRFOn: data[i]['IsRRFOn'],
							IsRRSOn: data[i]['IsRRSOn'],
							ContactID: data[i]['ContactID'],
							AddressID: data[i]['AddressID'],
							Sequence: i + 1,
							NotifyAddr: data[i]['NotifyAddr'],
							EncryptStatus: data[i]['EncryptStatus'],
							CanonicalAddress: data[i]['CanonicalAddress']
						});
				}
			}

            fxcRequest.post('/User/Contact/SaveGroup',
                {
                    Id: $('#ContactGroupId').val(),
                    Action: action,
                    GroupName: $('#GroupName').val(),
                    AddressBookId: $('#ContactAddrBookId').val(),
                    Description: $('#DescriptionGroup').val(),
                    Visibility: $('#ContactVisibilityId').val(),
                    ListDetail: listData
                },
                function (data) {

                    $('#ContactGroupId').val(data.Id);
                    swal({
                        title: $globalMessages.swal.success.title,
                        text: $globalMessages.swal.success.text,
                        type: "success",
                        showConfirmButton: true
                    }, function (e) {
                        window.setTimeout(function () {
                            var url = $("#RedirectTo").val();
                            if ($("#RedirectTo").length > 0) {
                                var Id = $("#ContactAddrBookId option:selected").val() + "";
                                var Name = $("#ContactAddrBookId option:selected").text() + "";
                                fxcontent.load(url.replace('__ID__', Id).replace('__Name__', Name));
                            }

                            if (backToGrid == 1) {
                                var addressBook = $('#addressBook').val();

                                if (addressBook == 'domain') {
                                    $.addressBook.refresh();
                                    $.sectionproperties.SixthLevel();
                                }
                                else {
                                    $.addressBook.refresh();
                                    $.sectionproperties.FirstLevelView();
                                }
                            }

                        }, 10);

                    }, function (error) {
                    });
                });
        },
        getForm: function (contactGroupId) {
            fxcRequest.get('/User/Contact/GetGroup',
                {
                    Id: contactGroupId
                },
                function (data) {
                    dataForm = data;
                    $.contactGroup.resetFields(dataForm);
                });
        }
    };

    /*Contact List*/
    var $grid;
    var gridId = "#gridContactGroupDetails";
    var popUpModal = "#add-edit-modal";
    var dataContact = null;
    var formContactGeneralID = "#form-user-contactListGeneral";
    var addressTab = false;

    var contactListValidation = function () {
        /*Create New Contact from General Recipient*/
        $("#form-user-contactListGeneral").validate({
            ignoreTitle: true,
            rules: {
                recipient_name: {
                    required: true,
                    noSpace: true
				},
                RecipientDelivery: {
                    required: true,
                    noSpace: true
                },
                recipient_email: {
                    email: true,
                    noSpace: true
                },
                recipient_address: {
                    required: true,
                    noSpace: true
				},
				recipient_emailAddress: {
					required: true,
                    email: true,
                    noSpace: true
				},
				recipient_UrlAddress: {
                    required: true,
                    noSpace: true
				},
                recipient_faxNumber: {
                    required: true,
                    noSpace: true
                },
                recipient_mobilenumber: {
                    required: true,
                    noSpace: true
                },
                recipient_phonenumber: {
                    required: true,
                    noSpace: true
                },
                recipient_path: {
                    required: true,
                    noSpace: true
                },
                recipient_userID: { checkRequired: "recipient_userPassword" },
                recipient_userPassword: { checkRequired: "recipient_userID" }

            },
            submitHandler: function (form) {
                $.contactGroupDetail.save(0);
            }
        });
        /*Create New Contact from Address Book*/
        $("#form-user-contactListAddressBook").validate({
            rules: {

            },
            messages: {

            },
            submitHandler: function (form) {
                $.contactGroupDetail.save(1);
            }
        });
    };

    $.contactGroupDetail = {
        init: function (data) {
            contactListValidation();
            $.contactGroupDetail.createButtonClickHandler($('.btn-addContact'));
			$.contactGroupDetail.initTab();

			$("#RecipientDelivery").change(function () {
				$(formContactGeneralID).validate().resetForm();
			});
			/*init grid contact list*/
			$.contactGroupDetail.initGrid(true);
			$.contactGroupDetail.deleteButtonClickHandler($('#action-delete-contactlist'));
        },
		initGrid: function (emptyGrid) {
			emptyGrid = emptyGrid || false;
            var id = $(gridId);
            var pageSize = parseInt($("#pageSize").val());

            var col = [
				{
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: "ContactID", hidden: true },
				{ field: "AddressID", hidden: true },
				{ field: "AddressTypeID", hidden: true },
                { field: "IsContactGroupDisplayOnly", hidden: true },
                {
					field: "IsRRSOn",
					title: $contactGroup.grid.IsRssOn,
                    sortable: false,
                    width: 52,
					template: '<div class="kendo-container"> <i #= IsRRSOn == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
					field: "IsRRFOn",
					title: $contactGroup.grid.IsRrfOn,
                    sortable: false,
                    width: 52,
					template: '<div class="kendo-container"> <i #= IsRRFOn == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
				{ field: "DisplayName", title: $contactGroup.grid.DisplayName, width: 150, filterable: true },
				{ field: "CompanyName", title: $contactGroup.grid.CompanyName, width: 150, filterable: true },
				{ field: "DisplayAddress", title: $contactGroup.grid.DisplayAddress, width: 300, filterable: true },
				{ field: "AddressTypeLabel", title: $contactGroup.grid.AddressTypeLabel, width: 150 },
				{ field: "NotifyAddr", title: $contactGroup.grid.NotifyEmail, width: 200 },
                {
                    attributes: {
                        "class": "disabledClickableRow"
                    },
                    headerAttributes: {
                        "aria-label": "delete",
                    },
                    title: " ",
                    width: 60,
                    sortable: false,
                    template: function (dataRow) {
						var result = '<div class="k-delete-row"><a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" data-id="' + dataRow.ContactID + '" id="del-' + dataRow.AddressID + '-' + dataRow.AddressTypeID + '" href="javascript:void(0)" title="' + $globalMessages.grid.delTooltip +'"><i class="fa fa-trash-o"></i></a>';
                        return result;
                    }
                }
            ];

            var dataSource = {
                transport: {
                    read: {
                        url: "/User/Contact/GetGroupList",
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
							Page: options.page,
							Take: emptyGrid ? 0 : options.take,
                            Skip: options.skip,
                            filter: "",
                            Id: $('#ContactGroupId').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "GridDetail",
					total: "Count",
					model: {
						id: "ContactID"
					}
                }
            };

			var obj = {};
			obj.totalInputType = "#TotalGrid-gridContactGroupDetails";
            obj.customizeCheckbox = true;
            obj.allowSelectMultipleRow = true;
            obj.pageSize = pageSize;
			$grid = kendogridcustomization.init(id, dataSource, col, obj);
			
			$.contactGroupDetail.deleteRowClickHandler();
        },
        initTab: function (e) {
            $('ul#MsgRecipient a[data-bs-toggle="tab"]').on('shown.bs.tab', function (h) {
                var target = $(h.target).attr("href"); /* activated tab*/
                switch (target) {
                    case "#addAddressBook":
                        if (!addressTab) {

                            var objContact = {};
                            objContact.postSelectFn = $.userAddress.initGrid;
                            objContact.dataSource = "/Common/ConfigureAddrBook?removeexternalab=true";
                            objContact.reselectChild = true;
                            objContact.selectFirstNode = true;
                            objContact.lazyLoading = true;

                            $contactTree = treeview.init("recContactTree", "recContactName", "recContactID", objContact);

                            /* Mobile */
                            var objAddBook = {};
                            objAddBook.postSelectFn = $.userAddress.selectContactAddBook;
                            objAddBook.dataSource = "/Common/ConfigureAddrBook?removeexternalab=true";
                            objAddBook.reselectChild = true;
                            objAddBook.selectFirstNode = true;
                            objAddBook.lazyLoading = true;
                            objAddBook.declareType = "textbox";

                            $contactTreeMobile = treeview.init("recAddBookTree", "recAddBook-name", "recAddBook-id", objAddBook);

                            treeview.mapState($contactTree, $contactTreeMobile, true);

                            addressTab = true;

                            fxcRequest.get('/Common/GetUserDataSources',
                                {
                                    "RetrieveTypes": 7
                                },
                                function (data) {
                                    var optAll = [{ Disabled: false, Group: null, Selected: false, Text: "All", Value: "0" }];
                                    var updArray = $.merge(optAll, data.Results);
                                    $.sectionproperties.selectGenerator('DdlABFilter', updArray, 0, 0);
                                });
                        }
                        break;
                    default:
                        break;
                }
            });
		},

        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                dataContact = null;
                $.contactGroupDetail.resetFields(dataContact);

                $(popUpModal).modal("show");
                $('#form-user-contactListGeneral').validate().resetForm();
            });

        },
        deleteButtonClickHandler: function (e) {
            /* Adding .off('click') will prevent multiple firing of click event */
            $(e).off('click').on('click', function () {
                $(this).blur();
                $.contactGroupDetail.delete();
            });
		},
		deleteRowClickHandler: function (e) {
			$(gridId + " tbody").on("click", "a.remove", function (e) {
				var tr = $(e.target).closest("tr");
				var row = $(gridId).data("kendoGrid").dataItem(tr);
				if (row != null) {

					$(gridId).data("kendoGrid").dataSource.remove(row);

					$.toast({
						text: $globalMessages.toast.updated,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						loader: false,
						icon: 'info',
						hideAfter: 3500,
						stack: 6
					});
				}
			});
		},

        /* Logic */
        delete: function (e) {
            var grid = $(gridId).data("kendoGrid");
            var selectedItem = grid.select();

            if (selectedItem.length === 0) {
				swal("", $areaResources.swal.noContactSelected);
                return false;
            }

            var ArrayList = new Array();

            for (i = 0; i < selectedItem.length; i++) {
                for (j = 0; j < grid.dataSource.data().length; j++) {
                    var gridSource = grid.dataSource.at(j);
                    if (gridSource.uid == selectedItem[i].dataset.uid) {
                        grid.dataSource.remove(gridSource);
                    }
                }
            }

            $.toast({
                text: $globalMessages.toast.updated,
                position: 'bottom-right',
                loaderBg: '#ff6849',
                loader: false,
                icon: 'info',
                hideAfter: 3500,
                stack: 6
            });
        },
        refresh: function (e) {
            $(gridId).data("kendoGrid").dataSource.read();
            $(gridId).data("kendoGrid").refresh();
        },
        resetFields: function (data) {
            $(formContactGeneralID).trigger("reset");
            $(formContactGeneralID).validate().resetForm();
            $(".selectChange").each(function (e) {
                $(this).change();
            });

            /*Clear Grid selection*/
            if (addressTab) {
                var grid = $(gridAddressId).data("kendoGrid");
                grid.clearSelection();
            }
        },

        /*Post or Get Function*/
        save: function (action) {
              /*debugger
            console.log('Add Contact in group...');*/

            switch (action) {

                case 0:
                    fxcRequest.post('/User/Contact/Add',
                        {
                            DisplayName: $('#recipient_name').val(),
                            CompanyName: $('#recipient_company').val(),
							Address: $('#recipient_address').val(),
							Email: $('#recipient_emailAddress').val(), 
							Url: $('#recipient_UrlAddress').val(), 
                            FaxNumber: $('#recipient_faxNumber').val(),
                            MobileNumber: $('#recipient_mobilenumber').val(),
                            PhoneNumber: $('#recipient_phonenumber').val(),
                            Server: $('#recipient_server').val(),
                            Path: $('#recipient_path').val(),
                            Username: $('#recipient_userID').val(),
                            Password: $('#recipient_userPassword').val(),
							NotifyEmail: $('#recipient_email').val(),
                            AddressTypeId: $('#RecipientDelivery').val(),
                            IsContactGroupViewOnly: $('#recipient_viewonly').prop('checked'),
							AddressBookId: $('#ContactAddrBookId').val(),
                            ContactID: $('#ContactId').val(),
                            Sequence: $('#Sequence').val(),
                            Printer: $('#recipient_printer').val(),
                            Format: $('#recipient_Format').prop("checked"),
                            Visibility: $('#ContactVisibilityId').val()
                        },
                        function (data) {
                            $.toast({
                                text: $globalMessages.toast.updated,
                                position: 'bottom-right',
                                loaderBg: '#ff6849',
                                icon: 'info',
                                hideAfter: 3500,
                                stack: 6
                            });

                            $(popUpModal).modal("hide");
                            var grid = $(gridId).data("kendoGrid");
                            grid.dataSource.add(data);
							grid.refresh();
							swal.close();
                        },
                        function (error) {
                            swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                        }, true);
                    break;
                case 1:
                    /*Create New Contact from Address Book*/
                    var grid = $(gridAddressId).data("kendoGrid");
                    var sel = grid.select();

                    if (sel.length > 0) {
                        var gridContactGroup = $(gridId).data("kendoGrid");
                        var dataContactGroup = gridContactGroup.dataSource.data();
                        var resultSuccess = 0;
                        var resultFailed = 0;

                        $.each(sel, function (idx, row) {

                            var item = grid.dataItem(row);

                            var pushItem = {
                                Sequence: idx + 1,
                                AddressBook: 0,
                                ContactID: item.ContactID,
								AddressID: item.AddressID,
                                AddressTypeID: item.AddressTypeID,
                                IsContactGroupDisplayOnly: item.IsContactGroupDisplayOnly,
								IsRRSOn: item.IsRRSOn,
								IsRRFOn: item.IsRRFOn,
                                DisplayName: item.DisplayName,
                                CompanyName: item.CompanyName,
                                DisplayAddress: item.DisplayAddress,
                                AddressTypeLabel: item.AddressTypeLabel,
								NotifyAddr: item.NotifyAddress,
                                Status: item.Status,
                                EncryptStatus: item.EncryptStatus,
                                CanonicalAddress: item.CanonicalAddress
							};

                            /* Check if AddressId already exist */
                            var pushData = true;
							for (value in dataContactGroup) {
								if ((item.AddressTypeID === "99" && dataContactGroup[value].ContactID === item.ContactID) || (item.AddressTypeID !== "99" && dataContactGroup[value].AddressID === item.AddressID) ) {
                                    pushData = false;
                                }
                            }

                            /* End */
                            if (pushData) {
                                gridContactGroup.dataSource.add(pushItem);
                                resultSuccess++;
                            }
                            else {
                                resultFailed++;
                            }
                        });
                        if (resultSuccess) {
                            $.toast({
                                text: $areaResources.toast.table.update.withContacts.strFormat(resultSuccess), /*'Table had been updated with ' + resultSuccess + ' contact(s)',*/
                                position: 'bottom-right',
                                loaderBg: '#ff6849',
                                icon: 'info',
                                hideAfter: 3500,
                                stack: 6
                            });
                        }

                        if (resultFailed) {
                            $.toast({
                                text: $areaResources.toast.table.update.errorWithContacts.strFormat(resultFailed), /*"Failed to add the " + resultFailed + " contact(s) due to duplication.",*/
                                position: 'bottom-right',
                                loaderBg: '#ff6849',
                                icon: 'warning',
                                hideAfter: 3500,
                                stack: 6
                            });
                        }

                        $(popUpModal).modal("hide");
                        gridContactGroup.refresh();
                    }
                    else {
						swal("", $areaResources.swal.noSelectionMade, "error");
                    }
                    break;
                default:
            }
        }
    };

    /*User Address List*/
    var $gridAddress;
    var gridAddressId = "#gridAddressBook";
    var selectedFilter = 0;
    var requestObj;

    $.userAddress = {
        initGrid: function (e, obj) {
            var contactcat = "";
            var searchText = $.trim($('#userAddressBookSearch').val());
            var addrBookID = "";

            var pageSize = parseInt($("#pageSize").val());

            var id = $(gridAddressId);
            if (obj != null) {
                requestObj = obj;
                contactcat = obj.category;
            }

            if (e != null) {
                addrBookID = e;
            }

            contactTreeCall = true;
            var getData = $contactTreeMobile.getNodeById(addrBookID);
            if (getData != undefined) {
                $contactTreeMobile.unselectAll();
                $contactTreeMobile.select(getData);
            }

            var columns = [];
            columns = [
                { field: "checkboxSelection", selectable: true, width: 64, sortable: false },
                { field: "id", title: "ID", hidden: true, width: 100 },
                { field: "SelectableContact", title: $globalMessages.grid.contactName, width: 300, hidden: false },
                { field: "EncryptStatus", title: "EncryptStatus", hidden: true }
            ];

            var dataSource = {
                transport: {
                    read: {
                        url: "/Common/GetUser",
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var sortBy = "";
                        var direction = "";
                        if (options.sort != null && options.sort.length > 0) {
                            var s = options.sort[0];
                            sortBy = s.field;
                            direction = s.dir;
                        }

                        var result = {
                            Type: "4",
                            Category: Number(contactcat),
                            AddrBookID: addrBookID,
                            SearchText: searchText,
                            Page: options.page,
                            Limit: options.pageSize,
                            SortBy: sortBy,
                            Direction: direction,
                            SelectedFilter: selectedFilter
                        };
                        return result;
                    }
                },
                schema: {
                    data: "UserAddrBookList",
					total: "Total",
					model: {
						id: "id"
					}
                },
                serverPaging: true,
                serverSorting: true
            };

            var objParams = {};
            objParams.allowSelectMultipleRow = true;
            objParams.pageSize = pageSize;

            $gridAddress = kendogridcustomization.init(id, dataSource, columns, objParams);

            contactTreeCall = false;

            /*Search Action Handler*/
            $.userAddress.searchButtonClickHandler($('#userAddressBookSearchButton'));
            $.userAddress.searchPressEnter($('#userAddressBookSearch'));
        },
        selectContactAddBook: function (currentAddBookId) {
            if (!contactTreeCall) {
                var getData = $contactTree.getNodeById(currentAddBookId);
                if (getData != undefined) {
                    $contactTree.unselectAll();
                    $contactTree.select(getData);
                }

                contactTreeCall = false;
            }
        },

        /*Btn Action*/
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.userAddress.search();
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    enter.preventDefault();
                    $.userAddress.search();
                }
            });
        },
        onChangeFilter: function (e) {

            selectedFilter = e;
            $.userAddress.initGrid(requestObj.id, requestObj);
        },

        /* Logic */
        search: function (e) {
            $.userAddress.initGrid(requestObj.id, requestObj);
        }

        /*Post or Get Function*/
    };
})(window.jQuery);