﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-hopscotch",
        steps: [
            {
                target: "pageGuideBtn",
                title: "",
                content: $areaResources.uiGuide.buttonPageGuide,
                placement: "bottom",
                arrowOffset: "250px",
                xOffset: "-253",
                yOffset: "-10",
                zindex: 1002,
				isRtl: setIsRtl
            },
            {
                target: "accountDetailsBtn",
                title: "",
                content: $areaResources.uiGuide.buttonAccount,
                placement: "bottom",
                arrowOffset: "250px",
                xOffset: "-253",
                yOffset: "-10",
                zindex: 1002,
				isRtl: setIsRtl
            },
            {
                target: "notificationsBtn",
                title: "",
                content: $areaResources.uiGuide.buttonNotification,
                placement: "bottom",
                arrowOffset: "250px",
                xOffset: "-253",
                yOffset: "-10",
				zindex: 1002,
				isRtl: setIsRtl
            },
            {
                target: "fxcMenu",
                title: "",
                content: $areaResources.uiGuide.buttonSideBar,
                placement: "right",
                arrowOffset: "13px2",
                xOffset: "-10",
                yOffset: "-8",
				zindex: 1002,
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true,
        onClose: function () {
            $.fxcUserUiGuide.storeHopScotchState();
            hopscotch.endTour(true);
        }
    };
    var stateName = "fxc-user-hopscotch-state";
    var fxcUser = "";
    var hopscotchState = { "users": [] };
    $.fxcUserUiGuide = {
        init: function (fxcUser) {
            var state = $.sharedUiGuide.hasLocalStorage() ? localStorage.getItem(stateName) : $.sharedUiGuide.getCookie(stateName);

            if (state) {
                var stateObj = JSON.parse(state);
                var users = stateObj.users;
                var found = false;

                $.each(users, function (i, userValue) {
                    if (userValue === fxcUser) {
                        found = true;
                        return;
                    }
                });

                if (!hopscotch.isActive && !found) {
                    /*
                    users.push(fxcUser);
                    hopscotch.startTour(tour);
                    */
                }

                hopscotchState.users = users;
            }
            else {
                /*
                hopscotchState.users.push(fxcUser);
                if (!hopscotch.isActive) hopscotch.startTour(tour);
                */
            }
        },
        storeHopScotchState: function () {
            $.sharedUiGuide.storeState(stateName, hopscotchState);
        }
    };
})(window.jQuery);