﻿$.formvalidation = {
    init: function (e) {
        $('input').on('change', function (evt) {
            try {
                $(this).valid();
            }
            catch (err) {
            }
        });

        jQuery.validator.addMethod("multiselectrequired", function (value, element) {
            return $('#' + element.id + ' option').length;
        }, $.validator.messages.required);

        jQuery.validator.addMethod("fxcDateFormat", function (value, element, params) {
            var dateFormat = params[0];
            if (value.length) {
                return moment(value, dateFormat, true).isValid();
            }

            return true;
        }, $.validator.messages.multiSelect);

        jQuery.validator.addMethod("checkRequired", function (value, element, param) {
            if ((value.length && $("input[name='" + param + "']").val().length) || ($("input[name='" + param + "']").val().length == 0)) {
                return true;
            }
            return false;
        }, $.validator.messages.required);

        jQuery.validator.addMethod("checkOptionalRequired", function (value, element, param) {
            var arrayLength = param.length;
            var tempSuccess = true;

            for (var i = 0; i < arrayLength; i++) {
                if (!(value.length && $("input[name='" + param[i] + "']").val().length) && !($("input[name='" + param[i] + "']").val().length == 0)) {
                    tempSuccess = false;
                }
            }

            return tempSuccess;
        }, $.validator.messages.required);

        jQuery.validator.addMethod("requiredGrid", function (value, element) {
            var result = $('#' + element.id + "Total").val();
            if (result == "" || result == 0) {
                return false;
            }
            return true;

        }, $.validator.messages.gridMinLength);

        jQuery.validator.addMethod("noSpace", function (value, element) {
            return value == '' || value.trim().length != 0;
        }, $.validator.messages.noSpaceXRequired);

        jQuery.validator.addMethod("IPAddress", function (value, element) {
            var regex = new RegExp("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b");
            var key = value;

            if (!regex.test(key)) {
                return false;
            }
            return true;
        }, $.validator.messages.ip);

        jQuery.validator.addMethod("specialChars", function (value, element) {
            var regex = new RegExp("^[a-zA-Z0-9]+$");
            var key = value;

            if (!regex.test(key)) {
                return false;
            }
            return true;
        }, $.validator.messages.special);

        jQuery.validator.addMethod("timeMustGreaterThan", function (value, element, params) {
            var result = false;
            var compareId = params[0];
            var startControlId = '#' + compareId;
            var startTimeControl = $(startControlId).data("kendoTimePicker");

            var endControlId = '#' + element.id;
            var endTimeControl = $(endControlId).data("kendoTimePicker");

            var startTime = startTimeControl.value();
            var endTime = endTimeControl.value();

            if (startTime && endTime) {
                startTime = new Date(startTime);
                endTime = new Date(endTime);

                if (endTime > startTime) {
                    result = true;
                }
            }

            return result;
        }, "End Time Must Greater Than Start Time");

        jQuery.validator.addMethod("requiredIf", function (value, element, params) {
            var compareId = params[0]; /*control to compare*/
            var value = params[1]; /*control value to compare*/

            var isValid = true;
            var controlId = '#' + compareId;
            var controlValue = $(controlId).val();

            var elemetValue = element.value;
            if (controlValue == value) {
                if (elemetValue == null || elemetValue == "" || elemetValue == undefined) {
                    isValid = false;
                }
            }

            return isValid;
        }, "This Field Required!");

        jQuery.validator.addMethod("passwordFormat", function (value, element) {
            let password = value;
            if (!(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[^a-zA-Z\d]).{6,}$/.test(password))) {
                return false;
            }
            return true;
        }, $.validator.messages.passwordFormat);

        jQuery.validator.addMethod("prefixRuleFormat", function (value, element) {
            if (value.length && !(/^\*?[\d]*$/.test(value))) {
                return false;
            }
            return true;
        }, $.validator.messages.prefixRuleFormat);

        jQuery.validator.addMethod("faxNumberExtension", function (value, element) {
            if (!(/^(([.,:;iIwWxpP&])+\d*)*$/.test(value))) {
                return false;
            }
            return true;
        }, $.validator.messages.faxNumExtension);
    }
};