﻿(function ($) {
    var selectedid;
    $.moveselection = {
        init: function (id) {
            selectedid = id;
            $.moveselection.moveAlltoAssigned($('.div-' + selectedid + ' .btn-movealltoAssigned-' + selectedid));
            $.moveselection.moveAlltoUnassigned($('.div-' + selectedid + ' .btn-movealltoUnassigned-' + selectedid));
            $.moveselection.movetoAssigned($('.div-' + selectedid + ' .btn-movetoAssigned-' + selectedid));
            $.moveselection.movetoUnassigned($('.div-' + selectedid + ' .btn-movetoUnassigned-' + selectedid));
        },
        moveAlltoAssigned: function (e) {
            $(e).on('click', function () {
                $.moveselection.moveSelectItem('Unassigned-' + selectedid, 'Assigned-' + selectedid, true);
            });
        },
        moveAlltoUnassigned: function (e) {
            $(e).on('click', function () {
                $.moveselection.moveSelectItem('Assigned-' + selectedid, 'Unassigned-' + selectedid, true);
            });
        },
        movetoAssigned: function (e) {
            $(e).on('click', function () {
                $.moveselection.moveSelectItem('Unassigned-' + selectedid, 'Assigned-' + selectedid, false);
            });
        },
        movetoUnassigned: function (e) {
            $(e).on('click', function () {
                $.moveselection.moveSelectItem('Assigned-' + selectedid, 'Unassigned-' + selectedid, false);
            });
        },
        moveSelectItem: function (sourceId, targetId, selectAll) {
            var selectedItem;
            var sid;
            var tid;
            if (selectAll) {
                sid = "." + sourceId + " select option";
                selectedItem = $(sid);
            } else {
                sid = "." + sourceId + " select";
                selectedItem = $(sid).find(":selected");
            }

            tid = "." + targetId + " select";
            $.moveselection.populateMultiSelectItem(selectedItem, tid, false);
        },

        populateMultiSelectItem: function (selectItem, targetId, createTag) {
            var newOption;
            $.each(selectItem, function (i, e) {
                if (createTag) {
                    newOption = "<option value='" + e.Value + "'>" + e.Text + "</option>";
                } else {
                    newOption = e;
                }
                $(targetId).append(newOption);
            });
            $.moveselection.resetMoveButton();
        },
        resetMoveButton: function (e) {
            var unassignedDisabled = false;
            var assignedDisabled = false;
            if ($('.Unassigned-' + selectedid + ' select option').length == 0) {
                assignedDisabled = true;
            }
            if ($('.Assigned-' + selectedid + ' select option').length == 0) {
                unassignedDisabled = true;
            }
            $('.div-' + selectedid + ' .btn-movealltoAssigned-' + selectedid).prop("disabled", assignedDisabled);
            $('.div-' + selectedid + ' .btn-movetoAssigned-' + selectedid).prop("disabled", assignedDisabled);

            $('.div-' + selectedid + ' .btn-movealltoUnassigned-' + selectedid).prop("disabled", unassignedDisabled);
            $('.div-' + selectedid + ' .btn-movetoUnassigned-' + selectedid).prop("disabled", unassignedDisabled);
        }
    };
})(window.jQuery);