﻿(function ($) {
    var $grid;
    /*domain-user select modal*/

    $('.userselectiondomainId').click(function (e) {
        $('#userselection-modal').modal('show');
        $('body').css('overflow', 'hidden');
    });

    var $userselectiondomainselecttree = $('#userselectiondomainselecttree').tree({
        primaryKey: 'id',
        dataSource: '/Common/ConfigureDomain',
        checkboxes: false,
        uiLibrary: 'bootstrap4'
    });

    $userselectiondomainselecttree.on('dataBound', function (e) {
        $userselectiondomainselecttree.expandAll();
    });

	$userselectiondomainselecttree.on('select', function (e, node, id) {
        var idTxt = "li[data-id=" + id + "]";
        var text = $("div#userselection-modal " + idTxt + " span[data-role='display']").first().text();

        $('#userselectiondomainName').val(text);
        $('#userselectiondomainId').val(id);

        var type = $('#userselectionType').val();

        $.userselection.init($('#userSelectionGrid'));
        $.userselection.reload();
    });
    /*user grid*/
    $.userselection = {
        init: function (e) {

            if ($grid != null) {
                $grid.destroy();
            }

            var id = $('#userselectiondomainId').val();
            var type = $('#userselectionType').val();

            var blpid = $('#userselectionBlpid').val();

            var url = '/Common/UserSelection?domainid=' + id + '&type=' + type + '&blpid=' + blpid;
            $grid = $(e).grid({
                primaryKey: 'Id',
                dataSource: url,
                selectionMethod: 'checkbox',
                selectionType: 'multiple',
                mapping: {
                    dataField: 'UserList',
                    totalRecordsField: 'Total'
                },
                uiLibrary: 'bootstrap4',
                iconsLibrary: 'fontawesome',
                responsive: true,
                columns: [{
                    field: 'Id',
                    hidden: true
                }, {
                    field: 'UserName',
                    title: 'User Name',
                    sortable: true
                }, {
                    field: 'UserList',
                    hidden: true
                }, {
                    field: 'IsBLSubscriber',
                    hidden: true
                }, {
                    field: 'BLsID',
                    hidden: true
                }],
                pager: {
                    limit: 15,
                    sizes: [15, 25, 50, 100, 200, 500]
                }
            });

            $(e).removeClass('table-bordered');
            $grid.on('dataBound', function (e, records, totalRecords) {
                /* set selected value*/
                for (i = 0; i < records.length; i++) {
                    var id = records[i].Id;
                    var subs = records[i].IsBLSubscriber;
                    if (subs == 'true') {
                        $('#userSelectionGrid').grid().setSelected(id);
                        /*  console.log(id + '--databound');*/
                    }
                }
                $('div#userSelectionGrid tbody tr').addClass('clickable-row');
                $('#userSelectionGrid').on('click', '.clickable-row', function (event) {
                    var elementid = $(event.target).parent().children()[1];
                    var value = parseInt($(elementid).text());
                    /*if (value >= 101 && value <= 106) { } else {*/
                    if (value < 101 || value > 106) {
                        $grid.setSelected(value);
                    }
                });
            });
            $grid.on('rowSelect', function (e, $row, id, record) {
                var selectMode = $('#userselectionSelectMode').val();
                if ("1" == selectMode) {
                    $('.userselectionuserId').val(id);
                    $('.userselectionuserName').val(record.Name);
                    $('#userselection-modal').modal('hide');
                    $('body').css('overflow', 'auto');
                }
            });
        },
        searchUserHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
                    gridcustomization.clearNoRecords($grid);
                    $grid.reload({
                        page: 1,
                        searchText: $(this).val()
                    });
                }
            });
        },
        loadSelection: function () {
            var type = $('#userselectionType').val();
            if ("3" == type) {
                $.each($grid.getAll(), function (index, obj) {
                    var id = obj.Id;
                    var subs = obj.IsBLSubscriber;
                    if (subs == 'true') {
                        $('#userSelectionGrid').grid().setSelected(id);
                        /*console.log(id + '-----LoadSelection');*/
                    }
                });
            }
        },
        reload: function () {
            var type = $('#userselectionType').val();
            $grid.reload({
                page: 1,
                Type: type,
                ReloadDomainId: $('#userselectiondomainId').val(),
                ReloadBlpid: $('#userselectionBlpid').val()
            });
            $.userselection.loadSelection();
        },
        selectMultipleUser: function (e) {
            $(e).on('click', function () {
                var ids = $grid.getSelections().join().split(',');
                if (ids[0] !== '') {
                    $.each($grid.getSelections(), function (index, value) {
                        var name = $('#userSelectionGrid').grid().getById(value).Name;
                        if (index == 0) {
                            $('.userselectionuserName').val(name);
                        } else {
                            $('.userselectionuserName').val($('.userselectionuserName').val() + ',' + name);
                        }
                    });

                    $('.userselectionuserId').val(ids);
                    $('#userselection-modal').modal('hide');
                    $('body').css('overflow', 'auto');
                }
            });
        }
    };
})(window.jQuery);