﻿var fxcontent = fxcontent || {};
$(function () {
    String.prototype.strFormat = function () {
        a = this;
        for (k in arguments) {
            /* a = a.replace("{" + k + "}", arguments[k]); */
            /* Allow replace more than one argument with same index */
            var text = '\\{' + k + '\\}'
            a = a.replace(new RegExp(text, 'g'), arguments[k]);
        }
        return a;
    };

    /**
     * np = previous node navigation selected
     * nc = current node navigation selected
     */
    var np, nc, current_ajax
        , loader = '<div class="fxc-preloader"><svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"></circle></svg></div>';

    $.ajaxSetup({
        cache: false,
        complete: function (data) {
            fxcontent.redirectIfLoginResult(data.responseText);
        }
    });

    /*Handle Side navigation*/
    $(document).on('click', 'nav.sidebar-nav ul li a[href!="#"][data-href]', function (e) {
        e.preventDefault();
        custom.setNavigationVisbility();
        
        /*destroy context menu for msg*/
        $.contextMenu("destroy", ".ctxmenuMsg");
        $.contextMenu('destroy', ".dotcontextMenu");

        np = $("ul#sidebarnav li a.active");
        $("ul#sidebarnav .active:not(.opennav)").removeClass('active');

        nc = $(e.currentTarget);
        if (nc.parent().parent("ul").attr("id") == "sidebarnav") {
            $("ul#sidebarnav li.active").removeClass('active');
            nc.parent("li").addClass('special active');
        }
        else {
            $("ul#sidebarnav li.active.special").removeClass('active special');
            nc.addClass('active');
        }

        if (!nc.closest("ul").parent("li").hasClass("active:not(.opennav)")) {

            expandParents(nc.closest("ul").parent("li").children("[aria-expanded]").closest("ul"));
        }
        var url = location.hash.replace(/^#/, ''),

            container = $('.fxc-main-content-body');

        var linkUrl = nc.attr('href');
        var str1 = window.location.pathname;
        var str2 = linkUrl.substr(0, linkUrl.indexOf('?'));
        if (str1.indexOf(str2) != -1) {
            /*ajaxLoadUrl(url + nc.data("href"), container);*/
            ajaxLoadUrl(url + nc.attr("data-href"), container);
        }
        else {
            window.open(linkUrl);
        }
        $("ul#sidebarnav li:not(.active)>[aria-expanded='true']").removeClass('in');
        $("ul#sidebarnav li:not(.active)>[aria-expanded='true']").attr("aria-expanded", false);
    });

    /*Handle View navigation*/
    $(document).on('click', 'a.fxc-link[href!="#"][data-href]', function (e) {
        e.preventDefault();
        /*destroy context menu for msg*/
        $.contextMenu("destroy", ".ctxmenuMsg");
        $.contextMenu('destroy', ".dotcontextMenu");
        var linkUrl = $(e.currentTarget).attr('href');
        var str1 = window.location.pathname;
        var str2 = linkUrl.substr(0, linkUrl.indexOf('?'));
        if (str1.indexOf(str2) != -1) {
            var getLinkID = $(e.currentTarget).data("id") == undefined ? "" : $(e.currentTarget).data("id");
            var getNavLink = "nav.sidebar-nav ul li a#" + getLinkID.toLowerCase();
            if ($(getNavLink).length > 0) {
                $(getNavLink).trigger('click');
            }
            else {
                /*Select first default link if unable to load */
                $('nav.sidebar-nav ul li a[href!="#"]:first').trigger('click');
            }
        }
        else {
            window.location.href = linkUrl;
        }
	});

	/*Handle top navigation btn */
	$("#accountDetailsBtn, #notificationsBtn").on("click", function () {
        custom.setNavigationVisbility();
        /*destroy context menu for msg*/
        $('.context-menu-list').hide();
	});

    /*Handle top navigation*/
    $(document).on('click', 'ul.dropdown-nav li a[href!="#"][data-href]', function (e) {
        e.preventDefault();
        /*destroy context menu for msg*/
        $.contextMenu("destroy", ".ctxmenuMsg");
        $.contextMenu('destroy', ".dotcontextMenu");
        var linkUrl = $(e.currentTarget).attr('href');
        var str1 = window.location.pathname;
        var str2 = linkUrl.substr(0, linkUrl.indexOf('?'));
        if (str1.indexOf(str2) != -1) {
            var getLinkID = $(e.currentTarget).data("id") == undefined ? "" : $(e.currentTarget).data("id");
            var getNavLink = "nav.sidebar-nav ul li a#" + getLinkID.toLowerCase();
            if ($(getNavLink).length > 0) {
                $(getNavLink).trigger('click');
            }
            else {
                /*Select first default link if unable to load */
                $('nav.sidebar-nav ul li a[href!="#"]:first').trigger('click');
            }
        }
        else {
            window.location.href = linkUrl;
        }
    });

    /*Handle all parent non href clickable link */
    $(document).on('click', 'nav.sidebar-nav ul li a.clickablelink, nav.sidebar-nav ul li a.clickablelink-arrow', function (e) {
        e.preventDefault();

        var removeClass = false;
        if ($(e.currentTarget).closest("li").is(".opennav.defaultOpen")) {
            $("ul#sidebarnav .opennav.defaultOpen").removeClass("defaultOpen");
        }
        else if ($(e.currentTarget).closest("li").is(".opennav.active")) {
            $(e.currentTarget).closest("li").addClass("defaultOpen");
        }

        setTimeout(function () {
            $("ul#sidebarnav .opennav.defaultOpen:not(.active)").addClass("active");

            $("ul#sidebarnav .active>[aria-expanded='false']").attr("aria-expanded", true);
            $("ul#sidebarnav .active>[aria-expanded='true']").addClass('in');

            $("ul#sidebarnav .active>[aria-expanded='false']").attr("aria-expanded", true);

        }, 120);
    });

    /* fire links with targets on different window */
    $(document).on('click', 'nav.sidebar-nav ul li a[target="_blank"]', function (e) {
        e.preventDefault();
        var $this = $(e.currentTarget);

        window.open($this.attr('href'));
    });

    /* fire links with targets on same window */
    $(document).on('click', 'nav.sidebar-nav ul li a[target="_top"]', function (e) {
        e.preventDefault();
        var $this = $(e.currentTarget);

        window.location = ($this.attr('href'));
    });

    /**
     *
     * @param {any} url:
     * @param {any} container
        Loads the url via AJAX then append it to the container
     */
    function ajaxLoadUrl(url, container) {
        if (current_ajax !== null && current_ajax !== undefined) {
            /* abort current ajax content async request*/
            current_ajax.abort();
        }

        current_ajax = $.ajax({
            type: 'GET',
            url: url,
            async: true,
            cache: false,
            beforeSend: function () {            
                container.html(loader).delay(50).animate({ opacity: '1.0' }, 1000);
            },
            success: function (data) {
                if (data.TypeName && data.TypeName === "ServerError") {

                    var selected = $('li.active .hide-menu').text();

                    if (selected === 'New') {
                        var title = "New " + $('a.sidebar-nav-link.active').text().trim();
                        var errormsg = data.Value;
                        $invalid.renderPage(errormsg, title);

                    } else {
                        swal({
                            title: $globalMessages.swal.error.title,
                            text: data.Value,
                            type: "error"
                        },
                            function () {
                                var link = $('a.sidebar-nav-link.active').length > 0 ? $('a.sidebar-nav-link.active')
                                    : $('a.active');
                                link.trigger('click');
                            });
                    }
                } else {
					if (fxcRequest.isLoginResult(data)) {
                        var action = data.split('<form action="')[1].split('"')[0];
                        window.location.href = action;
                    } else {
						$(".preloader").fadeOut();
                        $('html body .dtp.hidden').remove();
                        $('html body .gj-list.gj-list-bootstrap.gj-dropdown-list-bootstrap.list-group').remove();
                        container.css({ opacity: '0.0' }).html(data).delay(50).animate({ opacity: '1.0' }, 300);

                        $(".fix-header .topbar").stick_in_parent({});
                    }
                }
            },
            error: function (error) {
                if (error.statusText !== 'abort') {
                    if (!error.isResponseValidationErrors && error.responseJSON.TypeName === "ServerError") {
                        swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
                    }
                    else if (error.isResponseValidationErrors) {
                        if (showLoader) {
                            swal.close();
                        }
                    }
                }
            }
        });

        current_ajax.done(function () {
            $(document).trigger('ready');
            /*Fn recalculate height from custom.min.js*/
			
			$(document).ready(function () {
				// document is loaded and DOM is ready
				$(".modal").on('shown.bs.modal', function () {
					custom.setModal($(this));
				});
				custom.initHeight();
			});
        });
    }
    function expandParents(element) {
        if ($(element).length > 0) {
            $(element).parent("li").addClass("active");

            var getUl = $(element).parent("li").children("[aria-expanded]");
            if ($(getUl).is('ul')) {
                $(element).parent("li").children("[aria-expanded]").attr("aria-expanded", true);
                $(element).parent("li").children("[aria-expanded]").addClass('in');
            }
            else {

                $(element).parent("li").children("[aria-expanded]").siblings("ul").attr("aria-expanded", true);
                $(element).parent("li").children("[aria-expanded]").siblings("ul").addClass('in');
            }
            if ($(element).parent("li").length > 0 && $(element).parent("li").closest("ul").length > 0) {
                expandParents($(element).parent("li").closest("ul"));
            }
        }
    }
    fxcontent.load = function (url) {
		if($("a[value='"+url+"']").length > 0){
			$("a[value='"+url+"']").click();
		}
		else
			ajaxLoadUrl(url, $('.fxc-main-content-body'));
    };
    fxcontent.redirectIfLoginResult = function (data) {
        if (fxcRequest.isLoginResult(data)) {
            var activeMenu = $('#sidebarnav li a.active');
            var activeLink = activeMenu.attr('href');
            var pathName = window.location.pathname;

            if (activeLink && pathName.indexOf(activeLink.split('?')[0]) !== -1) {
                window.location.href = fxcontent.constructUrl(activeMenu.attr('data-href'));
            } else {
                window.location.href = fxcontent.constructUrl(pathName);
            }
        }
    };
    fxcontent.constructUrl = function (returnUrl) {
        return '/login/?returnUrl=' + encodeURIComponent(returnUrl);
    };
});