﻿var fxcDateTimePicker = fxcDateTimePicker || {};
var fxcDatePicker = fxcDatePicker || {};
var obj = obj || {};

fxcDateTimePicker.init = function (id, defaultDateTime, obj) {
    /*website: http://www.daterangepicker.com/ */
    obj = obj || {};

    /* Configuration */
    var singleDatePicker = obj.singleDatePicker || true; /* Show only a single calendar to choose one date, instead of a range picker with two calendars. The start and end dates provided to your callback will be the same single date chosen.*/
    var autoUpdateInput = obj.autoUpdateInput || false; /* true/false) Indicates whether the date range picker should automatically update the value of the <input> element it's attached to at initialization and when the selected dates change.*/
    var timePickerIncrement = obj.timePickerIncrement || true; /*  (number) Increment of the minutes selection list for times (i.e. 30 to allow only selection of times ending in 0 or 30).*/
    var timePicker24Hour = obj.timePicker24Hour || true; /*  (true/false) Use 24-hour instead of 12-hour times, removing the AM/PM selection.*/
    var timePickerSeconds = obj.timePickerSeconds || true; /* (true/false) Show seconds in the timePicker.*/
    var opens = obj.opens || "left"; /*('left'/'right'/'center') Whether the picker appears aligned to the left, to the right, or centered under the HTML element it's attached to.*/
	var minDate = obj.minDate || "";
    var parentEl = obj.parentEl || "body"; /*jQuery selector of the parent element that the date range picker will be added to - if component is used in pop up modal pls add modal id/class */
    var startDate = obj.startDate || "";
    var endDate = obj.endDate || "";

    if (defaultDateTime.indexOf("hh") >= 0 || defaultDateTime.indexOf("h") >= 0)
    {
        timePicker24Hour = false;
    }
	var result = {
		parentEl: parentEl,
        showDropdowns: true,
        singleDatePicker: singleDatePicker,
        autoUpdateInput: autoUpdateInput,
        timePicker: true,
        format: defaultDateTime,
        timePicker24Hour: timePicker24Hour,
        timePickerIncrement: timePickerIncrement,
        timePickerSeconds: timePickerSeconds,
        buttonClasses: ['btn', 'btn-sm'],
        applyClass: 'btn-danger',
        cancelClass: 'btn-inverse',
        opens: opens,
        locale: {
            format: defaultDateTime
		}
    };

    if (minDate.length)
    {
        result.minDate = minDate;
    }

    if (startDate != "")
    {
        result.startDate = startDate;
    }

    if (endDate != "")
    {
        result.endDate = endDate;
    }

    $(id).daterangepicker(result);

    $(id).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format(defaultDateTime));
    });

    $(id).on('cancel.daterangepicker', function (ev, picker) {
        $(this).val('');
    });
};

fxcDatePicker.init = function (id, defaultDate, obj) {
    /*website: http://www.daterangepicker.com/ */
    obj = obj || {};

    /* Configuration */
    var singleDatePicker = obj.singleDatePicker || true; /* Show only a single calendar to choose one date, instead of a range picker with two calendars. The start and end dates provided to your callback will be the same single date chosen.*/
    var autoUpdateInput = obj.autoUpdateInput || false; /* true/false) Indicates whether the date range picker should automatically update the value of the <input> element it's attached to at initialization and when the selected dates change.*/
    var opens = obj.opens || "left"; /*('left'/'right'/'center') Whether the picker appears aligned to the left, to the right, or centered under the HTML element it's attached to.*/

    $(id).daterangepicker({
        showDropdowns: true,
        singleDatePicker: singleDatePicker,
        autoUpdateInput: autoUpdateInput,
        format: defaultDate,
        buttonClasses: ['btn', 'btn-sm'],
        applyClass: 'btn-danger',
        cancelClass: 'btn-inverse',
        opens: opens,
        locale: {
            format: defaultDate
        }
    });

    $(id).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format(defaultDate));
    });

    $(id).on('cancel.daterangepicker', function (ev, picker) {
        $(this).val('');
    });
};

