﻿var fxcNotificationStorage = fxcNotificationStorage || {};
$(function () {

    var parent = $('div.message-center');
    var storageKey = "_fxc.notification_";
    fxcNotificationStorage.insert = function (id, message, date) {
        var notifications = getStoredNotifications();
        if (!notifications)
            notifications = [];

        notifications.push({
            messageId: id,
            message: message,
            isRead: false,
            date: date
        });
        updateNotificationToStore(notifications);
        var notif = constructNotification({ messageId: id, message: message, date: date });
        parent.prepend(notif);
        $('#notifyHeartBeat').show();
        notifClickHandler();
    };

    fxcNotificationStorage.view = function (id) {
        var notifications = getStoredNotifications();
        var temp = filterNotifications(notifications, id);
        if (temp.length <= 0)
            $('#notifyHeartBeat').hide();

        updateNotificationToStore(temp);
        showMessageViewer(id);
    };

    var showMessageViewer = function (id) {
        var dualScreenLeft = window.screenLeft !== undefined ? window.screenLeft : window.screenX;
        var dualScreenTop = window.screenTop !== undefined ? window.screenTop : window.screenY;
        var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
        var features = 'width=900,height=500,resizable=true,scrollbars=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no, top=' + ((height / 2) - (500 / 2)) + dualScreenTop + ', left=' + ((width / 2) - (900 / 2)) + dualScreenLeft;
        var name = 'form-message-viewer_' + id;
        var winPopup = window.open('/message/viewer/' + id, name, features);
        winPopup.focus();
    };

    var filterNotifications = function (notifications, id) {
        return notifications.filter(function (element) {
            return element['messageId'] !== id;
        });
    };
 
    var updateNotificationToStore = function (notifications) {
        localStorage.setItem(storageKey, JSON.stringify(notifications));
    };

    var getStoredNotifications = function() {
        return JSON.parse(localStorage.getItem(storageKey));
    };

    var constructNotification = function (n) {
        return $('<a href="javascript:void(0)" data-item-id="' + n.messageId + '"><div class="btn btn-info btn-circle"><i class="ti-email"></i></div><div class="mail-contnet" style="margin-left: 8px;"><h5>New Message</h5><span class="mail-desc" title="'+ n.message +'">' + n.message + '</span> <span class="time">' + n.date + '</span></div></a>');
    };

    $(document).ready(function () {
        $('#notifyHeartBeat').hide();
        if ($("div.message-center").length) {
            $('div.message-center').slimScroll({
                height: 'auto'
            });
        }
        var notifications = getStoredNotifications();
        var hasNotification = false;
        for (var i in notifications) {

            var e = constructNotification(notifications[i]);
            parent.prepend(e);
            if (!notifications[i].isRead)
                hasNotification = true;
        }

        if (hasNotification)
            $('#notifyHeartBeat').show();

        notifClickHandler();
    });

    var notifClickHandler = function () {
        $('div.message-center a').click(function (e) {
            fxcNotificationStorage.view($(this).attr('data-item-id'));
            $(this).remove();
        });
    };
});