﻿var fxcRequest = {
    post: function (url, model, successCallback, errorCallback, showLoader = true, kendoCallback = null, headers = null, serverErrorCallback = null, async = true, beforeSend = null) {
        $.ajax({
            type: 'POST',
            url: url,
            async: async,
            data: model,
            beforeSend: function (xhr) {
                if (showLoader) {
                    swal({
                        title: $globalMessages.swal.loader.title,
                        text: $globalMessages.swal.loader.text,
                        imageUrl: '/Content/img/ajax-loading2.gif',
                        showConfirmButton: false,
                        closeOnClickOutside: false,
                        allowEscapeKey : false,
                    });
                }
                if (headers) {
                    for (var i = 0; i < headers.length; i++) {
                        xhr.setRequestHeader(headers[i].name, headers[i].value);
                    }
                }
                if (beforeSend!= null) {
                    beforeSend();
                }
            },
            success: function (data) {
                if (data.TypeName && data.TypeName === "ServerError") {
                    if (data.Message == "" || data.Message == null) {
                        swal($globalMessages.swal.error.title, data.Value, "error");
                    }
                    else {
                        swal($globalMessages.swal.error.title, data.Message, "error");
                    }
					if (serverErrorCallback != null) {
						serverErrorCallback(data);
					}
                } else {
                    if (!fxcRequest.isLoginResult(data)) successCallback(data);
                }
            },
            error: function (error) {
                if (!error.isResponseValidationErrors &&
                    error.responseJSON !== undefined &&
                    error.responseJSON !== null &&
                    error.responseJSON.TypeName === "ServerError") {
					swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
				} else if (error.isResponseValidationErrors) {
					if (showLoader) {
						swal.close();
					}
				}
				if (kendoCallback != null) {
					kendoCallback(error);
				}
            }
        });
    },
    get: function (url, model, successCallback, errorCallback, showLoader = false, headers = null, serverErrorCallback = null) {
        $.ajax({
            type: 'GET',
            url: url,
            data: model,
            beforeSend: function (xhr) {
                if (showLoader) {
                    swal({
                        title: $globalMessages.swal.loader.title,
                        text: $globalMessages.swal.loader.text,
                        imageUrl: '/Content/img/ajax-loading2.gif',
                        showConfirmButton: false,
                        closeOnClickOutside: false,
                        allowEscapeKey : false,
                    });
                }
                if (headers) {
                    for (var i = 0; i < headers.length; i++) {
                        xhr.setRequestHeader(headers[i].name, headers[i].value);
                    }
                }
            },
            success: function (data) {
                if (data.TypeName && data.TypeName === "ServerError") {
                    if (serverErrorCallback != null) {
                        serverErrorCallback(data);
                    }
                    else {
                        swal($globalMessages.swal.error.title, data.Value, "error");
                    }                    
                } else {
                    if (!fxcRequest.isLoginResult(data)) successCallback(data);
                }
            },
            error: function (error) {
                if (error.responseJSON !== undefined && error.responseJSON !== null) {
                    if (!error.isResponseValidationErrors && error.responseJSON.TypeName === "ServerError") {
                        swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
                    }
                    else if (error.isResponseValidationErrors) {
                        if (showLoader) {
                            swal.close();
                        }
                    }
                }
            }
        });
    },
    upload: function (uri, e, data, successCallback, showLoader = true) {
        /* Create FormData object*/
        var fileData = new FormData();
        var fileUpload = $(e).get(0);
        var files = fileUpload.files;

        /* append data to formData */
        var dataparams = new Array();
        $.each(data, function (key, obj) {

            if (obj.constructor === {}.constructor) {
                $.each(obj, function (sub, internal) {
                    dataparams.push({
                        name: key + '.' + sub,
                        value: internal
                    });
                });
            } else {
                dataparams.push({
                    name: key,
                    value: obj
                });
            }
        });

        console.log(dataparams);
        for (var i = 0; i < dataparams.length; i++) {
            fileData.append(dataparams[i].name, dataparams[i].value);
        }

        /* Looping over all files and add it to FormData object  */
        for (var n = 0; n < files.length; n++) {
            fileData.append(files[n].name, files[n]);
        }

        $.ajax({
            type: 'POST',
            url: uri,
            data: fileData,
            contentType: false,
            processData: false,
            beforeSend: function () {
                if (showLoader) {
                    swal({
                        title: $globalMessages.swal.loader.title,
                        text: $globalMessages.swal.loader.text,
                        imageUrl: '/Content/img/ajax-loading2.gif',
                        showConfirmButton: false,
                        closeOnClickOutside: false,
                        allowEscapeKey : false,
                    });
                }
            },
            success: function (data) {
                if (data.TypeName && data.TypeName === "ServerError") {
                    swal($globalMessages.swal.error.title, data.Value, "error");
                } else {
                    successCallback(data);
                }
            },
            error: function (error) {
                if (!error.isResponseValidationErrors &&
                    error.responseJSON !== undefined &&
                    error.responseJSON !== null &&
                    error.responseJSON.TypeName === "ServerError") {
                    swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
                }
				else if (error.isResponseValidationErrors) {
					if (showLoader) {
						swal.close();
					}
				}
            }
        });
    },
    isLoginResult: function (data) {
        if (typeof data === 'string' && data.indexOf('<!DOCTYPE html>') !== -1 && data.toLowerCase().indexOf('<form action="/login/') !== -1) return true;

        return false;
    }
};
var fxcRequest2 = {
    get: function (url, model, successCallback, obj) {
        obj = obj || {};
        var errorCallback = obj.errorCallback || null;
        var swalLoading = obj.swalLoading || false;
        var formLoading = obj.formLoading || false; /*divLoadingForm*/
        var blurForm = obj.blurForm || false; /*blur Text*/
        var targetDiv = obj.targetDiv || null;
        var headers = obj.headers || null;
        var serverErrorCallback = obj.serverErrorCallback || null;

        $.ajax({
            type: 'GET',
            url: url,
            data: model,
            beforeSend: function (xhr) {
                if (swalLoading) {
                    swal({
                        title: $globalMessages.swal.loader.title,
                        text: $globalMessages.swal.loader.text,
                        imageUrl: '/Content/img/ajax-loading2.gif',
                        showConfirmButton: false,
                        closeOnClickOutside: false,
                        allowEscapeKey: false
                    });
                }
                if (blurForm) {
                    $(targetDiv).find(".divLoadingForm").show();
                    $(targetDiv).addClass("blurText");
                }
                if (headers) {
                    for (var i = 0; i < headers.length; i++) {
                        xhr.setRequestHeader(headers[i].name, headers[i].value);
                    }
                }
            },
            success: function (data) {

                if (data.TypeName && data.TypeName === "ServerError") {
                    if (serverErrorCallback != null) {
                        serverErrorCallback(data);
                    }
                    else {
                        swal($globalMessages.swal.error.title, data.Value, "error");
                    }
                } else {
                    if (!fxcRequest.isLoginResult(data)) successCallback(data);
                }
                if (blurForm) {
                    $(targetDiv).find(".divLoadingForm").hide();
                    $(targetDiv).removeClass("blurText");
                }
            },
            error: function (error) {
                if (blurForm) {
                    $(targetDiv).find(".divLoadingForm").hide();
                    $(targetDiv).removeClass("blurText");
                }
                if (error.responseJSON !== undefined && error.responseJSON !== null) {
                    if (!error.isResponseValidationErrors && error.responseJSON.TypeName === "ServerError") {
                        swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
                    }
                    else if (error.isResponseValidationErrors) {
                        if (swalLoading) {
                            swal.close();
                        }
                    }
                }
            }
        });
    },
    post: function (url, model, successCallback, obj) {
        obj = obj || {};
        var async = obj.async != null ? obj.async : true;
        var errorCallback = obj.errorCallback || null;
        var swalLoading = obj.swalLoading || false;
        var formLoading = obj.formLoading || false; /*divLoadingForm*/
        var blurForm = obj.blurForm || false; /*blur Text*/
        var targetDiv = obj.targetDiv || null;
        var headers = obj.headers || null;
        var serverErrorCallback = obj.serverErrorCallback || null;
        var kendoCallback = obj.kendoCallback || null;

        $.ajax({
            type: 'POST',
            url: url,
            async: async,
            data: model,
            beforeSend: function (xhr) {
                if (swalLoading) {
                    swal({
                        title: $globalMessages.swal.loader.title,
                        text: $globalMessages.swal.loader.text,
                        imageUrl: '/Content/img/ajax-loading2.gif',
                        showConfirmButton: false,
                        closeOnClickOutside: false,
                        allowEscapeKey: false
                    });
                }
                if (blurForm) {
                    $(targetDiv).find(".divLoadingForm").show();
                    $(targetDiv).addClass("blurText");
                }
                if (headers) {
                    for (var i = 0; i < headers.length; i++) {
                        xhr.setRequestHeader(headers[i].name, headers[i].value);
                    }
                }
            },
            success: function (data) {
                if (data.TypeName && data.TypeName === "ServerError") {
                    swal($globalMessages.swal.error.title, data.Value, "error");
                    if (serverErrorCallback != null) {
                        serverErrorCallback(data);
                    }
                } else {
                    if (!fxcRequest.isLoginResult(data)) successCallback(data);
                }

                if (blurForm) {
                    $(targetDiv).find(".divLoadingForm").hide();
                    $(targetDiv).removeClass("blurText");
                }
            },
            error: function (error) {
                if (blurForm) {
                    $(targetDiv).find(".divLoadingForm").hide();
                    $(targetDiv).removeClass("blurText");
                }
                if (!error.isResponseValidationErrors && error.responseJSON !== undefined && error.responseJSON !== null && error.responseJSON.TypeName === "ServerError") {
                    swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
                } else if (error.isResponseValidationErrors) {
                    if (swalLoading) {
                        swal.close();
                    }
                }
                if (kendoCallback != null) {
                    kendoCallback(error);
                }
            }
        });
    },
};