﻿(function ($) {

	var importContactValidation = function () {

		jQuery.validator.addMethod("allowedDelimiter", function (value, element) {
			var reg = new RegExp('^[~!#%^*|]+$');
			return this.optional(element) || reg.test(value);
		}, $.validator.messages.delimiter);

		$('#formSubmit_importContact').validate({
			ignore: ".ignored",
			ignoreTitle: true,
			errorPlacement: function (error, element) {
				var p = element.parent(".dropify-wrapper");
				if (p.length) {
					error.insertAfter(p);
				}
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				FaxCoreUsertxt: {
					required: true,
					noSpace: true
				},
				ImportFile: {
					required: true,
					noSpace: true
				},
				AddressBook: {
					required: true,
					noSpace: true,
					normalizer: function (value) {
						return $.trim(value);
					}
				},
				ImportContactAddressBookName: {
					required: true,
					noSpace: true
				},
				ImportContactContactGroupName: {
					required: true,
					noSpace: true
				},
				ImportContactContactGroupDescription: {
					required: true,
					noSpace: true
				},
				TableName: {
					required: {
						depends: function (element) {
							var fileType = $('#ImportFileType').val();

							if (fileType == 'Access') {
								return true;
							} else {
								return false;
							}
						}
					}
				},
				CustomDelimiterFormat: {
					required: {
						depends: function (element) {

							var delimiterFormat = $('#DelimiterFormat').val();

							if (delimiterFormat == 'CustomDelimiter') {
								return true;
							} else {
								return false;
							}
						}
					},
					allowedDelimiter: true,
					maxlength: 1
				}
			},
			messages: {
				CustomDelimiterFormat: {
					maxlength: $.validator.messages.maxCharLength,
					allowedDelimiter: $globalMessages.validation.delimiter
				}
			},
			submitHandler: function (form) {

				if ($('#ImportFileType').val() === 'Access') {
					if ($('#TableName').val() !== '')
						$.importcontact.AccessFileReader('#ImportFile');
				} else {
					$.importcontact.import();
				}
			}
		});
		$('#formSubmit_importContact-FaxcoreHeader').validate({
			ignoreTitle: true,
			rules: {
			},
			messages: {

			},
			submitHandler: function (form) {
				var url = form.baseURI;
				var page;

				if (url.indexOf('admin') > -1)
					page = 'admin';
				else
					page = 'user';

				$.importcontact.save(page);
			}
		});
	};

	var FileList = {
		'Header': {},
		'Content': "",
		'HeaderList': "",
		'Byte': [],
		'DataUrl': ''
	};

	var navigatePageTo = function (e) {
		switch (e) {
			case "View1":
				$.sectionproperties.SecondLevel();
				break;
			case "View2":
				$.sectionproperties.ThirdLevel();
				break;
			case "View3":
				$.sectionproperties.FourthLevel();
				break;
			case "View4":
				$.sectionproperties.FifthLevel();
				break;
			case "View5":
				$.sectionproperties.SixthLevel();
				break;
			default:
		}
	};

	var AssignImportContactLevel = function (e) {

		switch (e) {
			case "View1":

				$.importcontact.importHandler($('.btn-import'));
				$.importcontact.resetHandler($('.btn-Reset'));
				$.importcontact.saveHandler($('.btn-save2'));

				$('.btn-back2').on('click', function (e) {
					$.sectionproperties.FirstLevelView();
				});
				break;
			case "View2":

				$.importcontact.importHandler($('.btn-import2'));
				$.importcontact.resetHandler($('.btn-Reset2'));
				$.importcontact.saveHandler($('.btn-save3'));

				$('.btn-back3').on('click', function (e) {
					$.sectionproperties.SecondLevel();
				});

				break;
			case "View3":

				$.importcontact.importHandler($('.btn-import3'));
				$.importcontact.resetHandler($('.btn-Reset3'));
				$.importcontact.saveHandler($('.btn-save4'));

				$('.btn-back4').on('click', function (e) {
					$.sectionproperties.ThirdLevel();
				});

				break;
			case "View4":

				$.importcontact.importHandler($('.btn-import4'));
				$.importcontact.resetHandler($('.btn-Reset4'));
				$.importcontact.saveHandler($('.btn-save5'));

				$('.btn-back5').on('click', function (e) {
					$.sectionproperties.FourthLevel();
				});

				break;
			case "View5":
				$.importcontact.importHandler($('.btn-import5'));
				$.importcontact.resetHandler($('.btn-Reset5'));
				$.importcontact.saveHandler($('.btn-save6'));

				$('.btn-back6').on('click', function (e) {
					$.sectionproperties.FifthLevel();
				});

				break;
			default:
		}
	};

	var fileType, viewClass, isFromImportContact, isDomainAddrBook, addressBookId, addressBookText;
	// this will identify which area view was the script is loaded
	var $area;
	$.importcontact = {

		init: function (e, f, domainAddrBook, area) {
			$area = area || '';
			isDomainAddrBook = domainAddrBook || false;
			$('#ImportFile').dropify({ allowedFileExtensions: ['csv', 'txt', 'mdb', 'accdb'] });
			viewClass = e;
			isFromImportContact = (f === null || f === undefined) ? false : f;

			/* Pass Import Contact partial view View class string*/
			AssignImportContactLevel(viewClass);

			if (isFromImportContact) {
				$.importcontact.userChangeEventHandler($('.' + viewClass + ' .msgapproval-multipleuserselection'));
			}
			else {
				$("#section-defaultSetting").removeClass("hide");
				$.sectionproperties.Hidden("FaxcoreUser", true);
			}


			importContactValidation();

			$.importcontact.assignValueToAddrBookTxtBox($('#AddressBook'));
			$.importcontact.assignValueToContactGrpTxtBox($('#ContactGroup'));
			$.importcontact.default();

			$.importcontact.resetfields();

			$('.' + viewClass + ' .msgapproval-multipleuserselection').on('click', function () {
				$('#modal-ImportContactUserSelection').modal('show');
			});

			document.getElementById('ImportFile').onchange = function () {
				fileType = this.files[0] === undefined ? '' : this.files[0].name.split('.').pop();

				if (fileType === "csv") {
					if (!$(".HiddenFileTypeAccess").hasClass("hide")) {
						$(".HiddenFileTypeAccess").addClass("hide");
					}
					if ($(".HiddenFileTypeCSV").hasClass("hide")) {
						$(".HiddenFileTypeCSV").removeClass("hide");
					}
				}

				if (fileType === "mdb" || fileType === "accdb") {
					if ($(".HiddenFileTypeAccess").hasClass("hide")) {
						$(".HiddenFileTypeAccess").removeClass("hide");
					}
					if (!$(".HiddenFileTypeCSV").hasClass("hide")) {
						$(".HiddenFileTypeCSV").addClass("hide");
					}
				}
			};
			$.importcontact.uploadEventHandler($('#ImportFile'));

		},
		default: function () {
			fxcRequest.get($area + '/Common/ImportContact/Default',
				null,
				function (data) {
					$.sectionproperties.selectGenerator('ImportContactVisibility', data.Visibility.Source, 1, 0);
					$.sectionproperties.selectGenerator('ImportContactAddressType', data.PreferAddressType.Source, 1, 0);
				},
				function (error) {
					swal("ERROR!", 'An error occured upon select', "error");
				}
			);
		},
		getFileProperty: function (input) {
			var name = document.getElementById(input);

			try {
				return {
					'name': name.files.item(0).name,
					'size': name.files.item(0).size,
					'type': name.files.item(0).type,
					'Path': $('#' + input).val(),
					'FileByte': FileList.Byte,
					'DataUrl': FileList.DataUrl
				};
			}
			catch (err) {
				return "";
			}
		},
		constructmodel: function (e) {
			switch (e) {
				case 0:
					return {
						'FaxCoreUser': $('#FaxCoreUsertxt').val(),
						'FileSelected': $.importcontact.getFileProperty("ImportFile"),
						'HeaderFormat': $('#HeaderFormat').val(),
						'ControlFile': $.importcontact.getFileProperty("ControlFile"),
						'FileType': $('#ImportFileType').val(),
						'HasHeader': $('#Header').prop('checked'),
						'DelimiterFormat': $('#DelimiterFormat').val(),
						'CustomDelimiterFormat': $('#CustomDelimiterFormat').val(),
						'TableName': $('#TableName').val(),
						'AddressBook': $('#AddressBook').val(),
						'ContactGroup': $('#ContactGroup').val(),
						'ContactGroupViewOnly': $('#ImportContactContactGroupViewOnly').prop('checked'),
						'FileAttachmentFormat': $('#FileAttachmentFormat').prop('checked'),
						'AddressType': $('#AddressType').val(),
						'Visibility': $('#Visibility').val(),
						'chkMSS': $('#chkMSS').prop('checked'),
						'chkMSF': $('#chkMSF').prop('checked')
					};
			}
		},
		resetfields: function () {
			/* Remove uploaded file */
			$('.dropify-clear').click();
			$(".dropify-wrapper").removeClass("has-error");
			$(".dropify-wrapper ul").html("");

			$('#formSubmit_importContact').trigger("reset");
			$('#formSubmit_importContact').validate().resetForm();
			$('#formSubmit_importContact').find(".selectChange").change();

			/* Clear User Tag */
			if (!isFromImportContact) {
				$.importcontact.populateContactGroup($('#ContactGroup'));
			}
			else {
				$("#FaxCoreUsertxt").tagsinput('removeAll');
				/* bootstrap state must be placed before disabled */

			}
			$.importcontact.faxCoreUsertxtEventHandler(isFromImportContact);

		},
		resetAddressBook: function () {
			$.importcontact.directPopulateAddrBookTxtBox($('#SelectedAddressBook').val(), isDomainAddrBook);
			$.importcontact.resetfields();
		},
		resetfieldsHeader: function () {
			$('#formSubmit_importContact-FaxcoreHeader').trigger("reset");
		},
		/* BTN Action */
		faxCoreUsertxtEventHandler: function (disabled) {
			$(".DivAddressBook .checkInputAddressBook").each(function (index) {
				$("#" + this.id).attr("disabled", disabled);
				/*Remove the all options except -New Address Book-*/

			});
			if (isFromImportContact) {
				$("#section-defaultSetting").addClass("hide");
				$("#AddressBook").find('option').slice(1).remove();
				$("#AddressBook").change();
				$("#AddressBook").attr("disabled", disabled);
			}
		},
		importHandler: function (e) {
			$(e).on('click', function () {
				$("#formSubmit_importContact").submit();

				/*Assign id to each label for mapping header mapping purpose */
				var labelList = $('.' + viewClass + ' label.control - label');

				$.each(labelList, function (index, value) {

					value.id = index + 1;
				});
			});
		},
		resetHandler: function (e) {
			$(e).on('click', function () {
				$.importcontact.resetfields();
			});
		},
		CSVFileReader: function (Selectedfile, DelimiterFormat) {
			var file = Selectedfile.files[0];
			var FileContent = {};
			var FileByte = "";
			var ContentList = [];
			var fileType = '';

			if (file !== null || file !== undefined) {
				var uploadFileType = file.name.split('.').pop();
				switch (uploadFileType) {
					case "csv":
						$('#ImportFileType').val("CSV");
						break;
					case "mdb":
						$('#ImportFileType').val("Access");
						break;
				}
			}

			var reader = new FileReader();
			reader.onload = function (progressEvent) {

				/* Clear Header List */
				FileList.HeaderList = "";

				var lines = this.result.split('\n');
				var arrayContentTemp;
				var rowContent = [];
				for (var linenumber = 0; linenumber < lines.length; linenumber++) {
					var tempWord = lines[linenumber].replace(' ', '');
					if (tempWord !== "") {
						if (linenumber === 0) {
							var Temp = tempWord.split(DelimiterFormat);
							var HeaderTemp = "";
							for (i = 0; i < Temp.length; i++) {
								var wordString = Temp[i].replace(/\r\n/g, "");
								wordString = wordString.replace(' ', '');
								wordString = wordString.replace('\r', '');
								Temp[i] = wordString;
								if (wordString !== '') {

									FileContent[wordString] = wordString;
									ContentList.push(wordString);
								}
							}
						}
					}
				}
				FileList.Header = FileContent;
				FileList.Content = rowContent;
				FileList.HeaderList = ContentList;
			};
			reader.readAsText(file);
		},
		AccessFileReader: function () {
			fxcRequest.upload($area + '/Common/ImportContact/UploadAccess', $('#ImportFile'),
				{
					TableName: $('#TableName').val()
				},
				function (data) {

					FileList.HeaderList = data.HeaderList;
					FileList.Byte = data.FileSelected.FileByte;
					swal.close();
					$.importcontact.import();
				}, showLoader = false);
		},
		getFileByte: function (Selectedfile) {
			var file = Selectedfile.files[0];

			var reader = new FileReader();
			reader.onload = function () {

				var dataURL = reader.result;
				FileList.DataUrl = dataURL;
			};

			reader.readAsDataURL(file);
		},
		saveHandler: function (e) {
			$(e).on('click', function () {
				$("#formSubmit_importContact-FaxcoreHeader").submit();
			});
		},
		PopulateValue: function (ContentList) {
			$.sectionproperties.selectGeneratorUsingArray('Header_DisplayName', ContentList, "DisplayName", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_FirstName', ContentList, "FirstName", 0);
			/* $.sectionproperties.selectGeneratorUsingArray('Header_MiddleName', ContentList, "MiddleName", 0); */
			$.sectionproperties.selectGeneratorUsingArray('Header_LastName', ContentList, "LastName", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_CompanyName', ContentList, "CompanyName", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Desc', ContentList, "Desc", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Email', ContentList, "Email", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Fax', ContentList, "Fax", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Http', ContentList, "Http", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_FTP', ContentList, "FTP", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_File', ContentList, "File", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Printer', ContentList, "Printer", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Mobile', ContentList, "Mobile", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_FaxRaw', ContentList, "FaxRaw", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_Phone', ContentList, "Phone", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_CSIDCallerID', ContentList, "CSID/CallerID", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_GroupName', ContentList, "GroupName", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_GroupDesc', ContentList, "GroupDesc", 0);
			$.sectionproperties.selectGeneratorUsingArray('Header_ContactGroupViewOnly', ContentList, "ContactGroupViewOnly", 0);
		},
		/* Post or Get Request */
		import: function () {
			/*Read import file*/
			$.importcontact.readImportFile($('#ImportFile')[0]);

			/*Wait to get header list*/
			setTimeout(function () {
				$.importcontact.clearHeaders();
				navigatePageTo(viewClass);
				$.importcontact.PopulateValue(FileList.HeaderList);
			}, 500);
		},
		save: function (page) {
			var formData = JSON.stringify($("#formSubmit_importContact").serializeArray());

			var formColumnHeaderData = JSON.stringify($("#formSubmit_importContact-FaxcoreHeader").serializeArray());

			/* Get selected address book */
			var addressBookId = $('#AddressBook').val() !== '' ? Number($('#AddressBook').val()) : 0;
			var addressBookValue = $('#AddressBook').val();

			var url;
			if (page == 'admin')
				url = $area + '/Common/ImportContact/Save';
			else
				url = $area + '/Common/ImportContact/SaveUser';

			addrBookID = $('#AddressBook').val() !== '' ? Number($('#AddressBook').val()) : 0;
			contactGrpID = $('#ContactGroup').val() !== '' ? Number($('#ContactGroup').val()) : 0;

			fxcRequest.post(url,
				{
					'FormData': formData,
					'FormColumnHeaderData': formColumnHeaderData,
					'FileSelected': $.importcontact.getFileProperty("ImportFile"),
					'ControlFile': $.importcontact.getFileProperty("ControlFile"),
					'AddrBookID': addrBookID,
					'AddrBookName': addrBookID == 0 ? $('#ImportContactAddressBookName').val() : $("#ImportContactAddressBookName option[value='" + $('#ImportContactAddressBookName').val() + "']").text(),
					'ContactGrpID': contactGrpID,
					'ContactGrpName': contactGrpID == 0 ? $('#ImportContactContactGroupName').val() : $("#ImportContactContactGroupName option[value='" + $('#ContactGroup').val() + "']").text(),
					'ContactGrpDesc': contactGrpID == 0 ? $('#ImportContactContactGroupDescription').val() : null,
					'ChkMSS': $('#chkMSS').prop('checked'),
					'ChkMSF': $('#chkMSF').prop('checked'),
					'FileAttachmentFormat': $('#FileAttachmentFormat').prop('checked'),
					'HasHeader': $('#Header').prop('checked'),
					'ContactGroupViewOnly': $('#ImportContactContactGroupViewOnly').prop('checked')
				},
				function (data) {

					var jsonData = JSON.parse(data.JsonArryExternalSource);

					var title = $globalMessages.swal.success.title;
					var text = $globalMessages.swal.success.text;
					var msgType = "success";

					if (jsonData.length == 0) {
						title = $globalMessages.swal.warningTitle;
						text = $globalMessages.grid.empty2 + " " + $globalMessages.button.save;
						msgType = "warning";
					}

					swal({
						title: title,
						text: text,
						type: msgType,
						showConfirmButton: true
					}, function (e) {
						window.setTimeout(function () {
							$.importcontact.resetfields();

							if (!isFromImportContact) {
								/* Set back to selected addressbook */
								$('#AddressBook').val(addressBookValue);
								$('#AddressBook').text(addressBookId);

								var addressBookType = $('#SelectedAddressBookType').val();

								if (addressBookType == 'personal') {
									/* User > My Address Book */
									$.sectionproperties.FirstLevelView(this);
									$.addressBook.initGrid($('#grid'));
								}
								else if (addressBookType == 'domain') {
									/* User > Domain Address Book */
									$.sectionproperties.SixthLevel(this);
									$.domainAddressBook.initGrid($('#domainContactGrid'));
								}
								else if (addressBookType == 'adminaddressbook') {
									/* Admin > Address Book */
									$.sectionproperties.SecondLevel();
									$.addrbookForm.resetFields();
								}
							}
							else {
								$.sectionproperties.FirstLevelView();
							}
						}, 10);
					});
				},
				function (error) {
					swal("ERROR!", 'An error occured upon import', "error");
				}
			);
		},
		userChangeEventHandler: function (e) {
			$(e).on('change', function (event, state) {
				/*isFromImportContact therefore domain is set as false */
				if (e.val() !== '') {
					$("#ImportContactAddressBookName").val("");
					$.importcontact.faxCoreUsertxtEventHandler(false);
					fxcRequest.get($area + '/Common/ImportContact/PopulateAddrBook',
						{
							'FaxCoreUserID': $('#FaxCoreUsertxt').val(),
							'IsDomainAddrBook': false
						},
						function (data) {
							$("#section-defaultSetting").removeClass("hide");
							$.sectionproperties.selectGenerator('AddressBook', data.AddressBook.Source, 0, false);
						},
						function (error) {
							swal("ERROR!", 'An error occured upon select', "error");
						}, false
					);
				}
				else {
					$.importcontact.faxCoreUsertxtEventHandler(true);
				}
			});
		},
		directPopulateAddrBookTxtBox: function (e, f) {
			if (f === true)
				isDomainAddrBook = true;
			else
				isDomainAddrBook = false;
			fxcRequest.get($area + '/Common/ImportContact/PopulateAddrBook',
				{
					/*'IsDomainAddrBook': window.location.pathname */
					'IsDomainAddrBook': isDomainAddrBook,
					'DomainID': $('#SelectedAddressBookDomain').val()
				},
				function (data) {
					$.sectionproperties.selectGenerator('AddressBook', data.AddressBook.Source,
						Number(e), false);
					$("#AddressBook").change();
					$("#AddressBook").attr("disabled", true);
					$.importcontact.populateContactGroup($('#ContactGroup'));
				},
				function (error) {
					swal("ERROR!", 'An error occured upon select', "error");
				}
			);
		},
		populateContactGroup: function (e) {
			if ($('#AddressBook').val() != null && $('#AddressBook').val() != 0) {
				fxcRequest.get($area + '/Common/ImportContact/PopulateContactGrp',
					{
						AddrBookID: Number($('#AddressBook').val()),
						'DomainID': $('#SelectedAddressBookDomain').val()
					},
					function (data) {
						$.sectionproperties.selectGenerator('ContactGroup', data.ContactGroup.Source, -1, false);
						$("#ContactGroup").change();
						$("#ImportContactContactGroupName").val("");
						$("#ImportContactContactGroupDescription").val("");
					},
					function (error) {
						swal("ERROR!", 'An error occured upon select', "error");
					}
				);
			}
			else {
				/*Remove the all options except first two*/
				$("#ContactGroup").find('option').slice(2).remove();
				$("#ContactGroup").val("-1").change();
			}

		},
		assignValueToAddrBookTxtBox: function (e) {
			$(e).on('change', function (event, state) {
				$("#ImportContactAddressBookName").val("");
				$.importcontact.populateContactGroup($('#ContactGroup'));
			});
		},
		assignValueToContactGrpTxtBox: function (e) {
			$(e).on('change', function (event, state) {
				$("#ImportContactImportContactContactGroupName").val("");
				$("#ImportContactContactGroupDescription").val("");
				var selectedContactGrpTxt = $('#ContactGroup').val();
				if (selectedContactGrpTxt == -1) {
					$('#ImportContactContactGroupViewOnly').bootstrapSwitch('state', false);
					$('#ImportContactContactGroupViewOnly').bootstrapSwitch('disabled', true);
					$(".DivContactGroup").addClass("hide");
				}
				else {
					$('#ImportContactContactGroupViewOnly').bootstrapSwitch('disabled', false);
					$(".DivContactGroup").removeClass("hide");
				}
			});
		},
		uploadEventHandler: function (e) {

			$(e).on('change', function (event, state) {

				fileType = this.files[0] === undefined ? '' : this.files[0].name.split('.').pop();

				if (fileType === "csv" || fileType === "txt") {
					if (!$(".HiddenFileTypeAccess").hasClass("hide")) {
						$(".HiddenFileTypeAccess").addClass("hide");
					}
					if ($(".HiddenFileTypeCSV").hasClass("hide")) {
						$(".HiddenFileTypeCSV").removeClass("hide");
					}

					$('#ImportFileType').val("CSV");
				}

				if (fileType === "mdb" || fileType === "accdb") {
					if ($(".HiddenFileTypeAccess").hasClass("hide")) {
						$(".HiddenFileTypeAccess").removeClass("hide");
					}
					if (!$(".HiddenFileTypeCSV").hasClass("hide")) {
						$(".HiddenFileTypeCSV").addClass("hide");
					}
					$('#ImportFileType').val("Access");
				}

				/* $.importcontact.resetfieldsHeader(); */

				if (fileType === "mdb" || fileType === "accdb") {
					$('#TableName').val('');
					$('#ImportFileType').val("Access");
				}
			});
		},
		readImportFile: function (e) {
			fileType = e.files[0] === undefined ? '' : e.files[0].name.split('.').pop();

			if (fileType === "csv" || fileType === "txt") {
				if (!$(".HiddenFileTypeAccess").hasClass("hide")) {
					$(".HiddenFileTypeAccess").addClass("hide");
				}
				if ($(".HiddenFileTypeCSV").hasClass("hide")) {
					$(".HiddenFileTypeCSV").removeClass("hide");
				}
				var delimiterFormat = $('#DelimiterFormat').val();
				if (delimiterFormat == "CSVDelimited") {
					delimiter = ",";
				}
				else if (delimiterFormat == "TabDelimited") {
					delimiter = "\t";
				}
				else if (delimiterFormat == "CustomDelimiter") {
					delimiter = $('#CustomDelimiterFormat').val();
				}

				$.importcontact.CSVFileReader(e, delimiter);
				$.importcontact.getFileByte(e);
			}

			if (fileType === "mdb" || fileType === "accdb") {

				if ($(".HiddenFileTypeAccess").hasClass("hide")) {
					$(".HiddenFileTypeAccess").removeClass("hide");
				}
				if (!$(".HiddenFileTypeCSV").hasClass("hide")) {
					$(".HiddenFileTypeCSV").addClass("hide");
				}
			}
		},
		clearHeaders: function () {
			$('#Header_DisplayName').empty();
			$('#Header_FirstName').empty();
			/* $('#Header_MiddleName').empty(); */
			$('#Header_LastName').empty();
			$('#Header_CompanyName').empty();
			$('#Header_Desc').empty();
			$('#Header_Email').empty();
			$('#Header_Fax').empty();
			$('#Header_Http').empty();
			$('#Header_FTP').empty();
			$('#Header_File').empty();
			$('#Header_Printer').empty();
			$('#Header_Mobile').empty();
			$('#Header_FaxRaw').empty();
			$('#Header_Phone').empty();
			$('#Header_CSIDCallerID').empty();
			$('#Header_GroupName').empty();
			$('#Header_GroupDesc').empty();
			$('#Header_ContactGroupViewOnly').empty();
		}
	};
})(window.jQuery);