﻿var detailTab = false;
var reset = false;
var bind = false;
var _detailtransaction = false;
var delegateeHistoryTab = false;
var notificationTab = false;
var historyTab = false;
var trackingTab = false;
var approvalTab = false;
var iv1; /*Message Viewer Image*/
var refreshLocation = 1;
var $selectedUser = null; /*Msg Viewer*/
var command = null;
var maxSlide = 4;
var flag = true;
var loadAnnotate = false;
var deselectImgCount = 0;

var validationUserSelection = function () {
    $('#formUserSelection-MsgViewer').validate({
        ignore: [],
        rules: {
            "listUserSelected-MsgViewer": { multiselectrequired: true },
        },
        messages: {
            "listUserSelected-MsgViewer": { multiselectrequired: $.validator.messages.required }
        },
        submitHandler: function (form) {
            $selectedUser = $.userSelectionMsgViewer.getListDataSource($("#listUserSelected-MsgViewer"));
            $.messageviewer.performMsgAction(command, $selectedUser);
        }
    });
};
$.userSelectionMsgViewer = {
    init: function (e) {
        validationUserSelection();
        

        $.userSelectionMsgViewer.searchButtonClickHandler($('#btn-userSelectionSearchButton-MsgViewer'));
        $.userSelectionMsgViewer.searchPressEnter($('input[data-role="search-active-userSelection-MsgViewer"]'));

        $.userSelectionMsgViewer.resetButtonClickHandler($('#BtnResetuserSelection-MsgViewer'));
        $.userSelectionMsgViewer.hideNavTextButtonClickHandler($('#navTabCollapse > a'));
    },
    initListView: function (e) {
        $('input[data-role="search-active-userSelection-MsgViewer"]').val("");
        var listBoxID = "listUserSelection-MsgViewer";
        var listBoxIDConnectWith = "listUserSelected-MsgViewer";

        fxcRequest.post('/Common/PopulateActiveUser',
            {
                DomainID: e,
                SearchText: "",
                GroupMember: $.userSelectionMsgViewer.getListDataSource($("#" + listBoxIDConnectWith)),
                ResetField: reset

            },
            function (data) {
                var returnObject = [];

                var dataSourceSelection = {
                    data: data.ActiveUserModel.ActiveUserList.Source
                };

                var objUserSelection = {};
                objUserSelection.dataTextField = "Text";
                objUserSelection.dataValueField = "Value";
				objUserSelection.connectWith = listBoxIDConnectWith;

                objUserSelection.staticSelectedListBox = !reset;

                var dataSourceSelected = {
                    data: data.ActiveUserModel.SelectedUserList.Source
                };

                returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                if (returnObject !== null) {
                    $listBoxSelection = returnObject.listBoxSelection;
                    $listBoxSelected = returnObject.listBoxSelected;
                }

                reset = false;
            },
            function (error) {
                swal('ERROR', 'error on load', 'error');
            }, false);

    },
    initTreeViewAction: function (e) {
        /* Action Forward to user // Assign Pop Up*/
        $("#userSelectionDomain-MsgViewer-id").val($('#defaultMsgViewerDomainID').val());
        var objUserSelection = {};
        objUserSelection.expandAll = true;
        objUserSelection.declareType = "textbox";
        objUserSelection.postSelectFn = $.userSelectionMsgViewer.initListView;
        treeview.init("userSelectionDomain-MsgViewer", "userSelectionDomain-MsgViewer-name", "userSelectionDomain-MsgViewer-id", objUserSelection);
    },
	initPopover: function (e) {
		$(e).find($('[data-toggle=popover]')).popover({
            html: true,
			title: function () {
                var template = $(this).data('title') +
                    '<button class="btn btn-link text-white float-right" onclick="$(\'[data-target=&quot;' + $(this).data('target') + '&quot;]\').popover(\'hide\');"><i class="fa fa-close fa-lg"></i></button>';

                return template;
            },
			content: function () {
                return $($(this).data('target')).html();
            }
        });
    },

    /*Btn Action*/
    resetButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.userSelectionMsgViewer.reset();
        });
    },
    searchButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.userSelectionMsgViewer.search();
        });
    },
    searchPressEnter: function (e) {
        $(e).on('keypress', function (event) {
            if (event.which === 13) {
                $.userSelectionMsgViewer.search();
                event.preventDefault();
            }
        });
    },
    hideNavTextButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
			$('.tabs-vertical').toggleClass('collapseTab');
			if ($(".tabs-vertical").hasClass("collapseTab")) {
				$(".tabs-vertical.collapseTab > #navTabCollapse > a").attr("title", $msgViewer.actionTitle.showMore);
			}
			else {
				$(".tabs-vertical > #navTabCollapse > a").attr("title", $msgViewer.actionTitle.showLess);
			}
			
        });
    },

    /*Logic*/
    getListDataSource: function (event) {
        var entityList = event.data("kendoListBox");
        $ids = [];
        if (entityList !== undefined) {
            var rows = entityList.dataItems();
            $(rows).each(function (index, row) {
                $ids[index] = row.Value;
            });
        }
        return $ids;
    },
    reset: function (e) {
        reset = true;
        $("#formUserSelection-MsgViewer").trigger("reset");
        $("#formUserSelection-MsgViewer").validate().resetForm();

        if (!bind) {
            $.userSelectionMsgViewer.initTreeViewAction();
            bind = true;
        }
        else {
            /*Reselect User From ID*/
            $("#userSelectionDomain-MsgViewer").tree().unselectAll();
            $("#userSelectionDomain-MsgViewer-id").val($('#defaultMsgViewerDomainID').val());
            var getUserData = $("#userSelectionDomain-MsgViewer").tree().getNodeById($("#userSelectionDomain-MsgViewer-id").val());

            if (getUserData !== undefined) {
                $("#userSelectionDomain-MsgViewer").tree().select(getUserData);
            }
        }
    },
    search: function (e) {
        /*$.userSelectionMsgViewer.initListView();*/
        var listBoxSelection = $("#listUserSelection-MsgViewer").getKendoListBox();
        var searchString = $('input[data-role="search-active-userSelection-MsgViewer"]').val();

        listBoxSelection.dataSource.filter({ field: "Text", operator: "contains", value: searchString });
    }
};

$.messageviewer = {
    showMessageViewerAdminSection: function (dataItem) {

        var folderType = dataItem.rowAdditionalObj.IsSearchMsg === 'true' ? dataItem.rowAdditionalObj.IsAdmin === 'true' ?
            'AdminSearch' : 'Search' : $('#folderName').val();

        /*Call From Main View -->fxc.user.message.index.js */
        messageID = dataItem.Id !== undefined ? dataItem.Id : dataItem.id;
        mid = dataItem.MID;
        approvalReqID = dataItem.ApprovalReqID !== undefined ? dataItem.ApprovalReqID : '';
        userMsgID = dataItem.UserMsgID !== '' ? dataItem.UserMsgID : 0;
        folderName = folderType;
        folderID = $('#folderId').val() !== undefined ? $('#folderId').val() : 0;
        delegatorID = $('input#DelegatorID').val() !== undefined ? $('input#DelegatorID').val() : '';
        delgProID = $('input#DelgProID').val() !== undefined ? $('input#DelgProID').val() : '';
        delegatorName = $('input#DelegatorName').val() !== undefined ? $('input#DelegatorName').val() : '';

        var url = "";

        if (dataItem.rowAdditionalObj.HideImageTab) {
            url = "/Message/Detail/" + mid + "/" + userMsgID + "/" + folderID + "/" + folderName + "/";
        }
        else {
            url = "/Message/Viewer/" + mid + "/" + userMsgID + "/" + folderID + "/" + folderName + "/";
        }

        if (dataItem.rowAdditionalObj.RefreshLocation) {
            url += dataItem.rowAdditionalObj.RefreshLocation + "/";
        }
        if (approvalReqID) {
            url += approvalReqID + "/";
        } else {
            approvalReqID = 0;
            url += approvalReqID + "/";
        }
        if (delegatorID) {
            url += delegatorID + "/";
        }
        if (delgProID) {
            url += delgProID + "/";
        }
        if (delegatorName) {
            url += delegatorName + "/";
        }

        fxcRequest.get('/Admin/Access/MessageViewer',
            {
            }, function (data) {
                if (data === false) {
                    swal($globalMessages.swal.error.title, "Access denied.", "error");
                } else {
                    swal.close();
                    var winPopup;
                    var w = 1200, h = 750;
                    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
                    var dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;
                    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
                    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
                    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
                    var top = ((height / 2) - (h / 2)) + dualScreenTop;
                    var features = 'width=' + w + ',height=' + h + ',resizable=' + true + ',scrollbars=no,' +
                        'toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no' +
                        ', top=' + top + ', left=' + left;
                    var name = 'form-message-viewer_' + mid + "_" + userMsgID;
                    winPopup = window.open(url, name, features);
                    winPopup.focus();

                    /*mark as read*/
                    if (fxcMessageHub.server !== undefined) {
                        fxcMessageHub.server.onMarkAsRead(dataItem.id);
                    }
                }
            }, function () { }, true, null, function (serverError) {
            });
    },
    showMessageViewer: function (dataItem) {
        var folderType = dataItem.rowAdditionalObj.IsSearchMsg === 'true' ? dataItem.rowAdditionalObj.IsAdmin === 'true' ?
            'AdminSearch' : 'Search' : $('#folderName').val();

        /*Call From Main View -->fxc.user.message.index.js */
        messageID = dataItem.Id !== undefined ? dataItem.Id : dataItem.id;
        mid = dataItem.MID;
        approvalReqID = dataItem.ApprovalReqID !== undefined ? dataItem.ApprovalReqID : '';
        userMsgID = dataItem.UserMsgID !== '' ? dataItem.UserMsgID : 0;
        folderName = folderType;
        folderID = $('#folderId').val() !== undefined ? $('#folderId').val() : 0;
        delegatorID = $('input#DelegatorID').val() !== undefined ? $('input#DelegatorID').val() : '';
        delgProID = $('input#DelgProID').val() !== undefined ? $('input#DelgProID').val() : '';
        delegatorName = $('input#DelegatorName').val() !== undefined ? $('input#DelegatorName').val() : '';

        var url = "";

        if (dataItem.rowAdditionalObj.HideImageTab) {
            url = "/Message/Detail/" + mid + "/" + userMsgID + "/" + folderID + "/" + folderName + "/";
        }
        else {
            url = "/Message/Viewer/" + mid + "/" + userMsgID + "/" + folderID + "/" + folderName + "/";
        }

        if (dataItem.rowAdditionalObj.RefreshLocation) {
            url += dataItem.rowAdditionalObj.RefreshLocation + "/";
        }
        if (approvalReqID) {
            url += approvalReqID + "/";
        } else {
            approvalReqID = 0;
            url += approvalReqID + "/";
        }
        if (delegatorID) {
            url += delegatorID + "/";
        }
        if (delgProID) {
            url += delgProID + "/";
        }
        if (delegatorName) {
            url += delegatorName + "/";
        }

        console.log(url);
        var winPopup;
        var w = 1200, h = 750;
        var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
        var dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;
        var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
        var left = ((width / 2) - (w / 2)) + dualScreenLeft;
        var top = ((height / 2) - (h / 2)) + dualScreenTop;
        var features = 'width=' + w + ',height=' + h + ',resizable=' + true + ',scrollbars=no,' +
            'toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no' +
            ', top=' + top + ', left=' + left;
        var name = 'form-message-viewer_' + mid + "_" + userMsgID;
        winPopup = window.open(url, name, features);
        winPopup.focus();

        /*mark as read*/
		if (fxcMessageHub.server !== undefined) {
            fxcMessageHub.server.onMarkAsRead(dataItem.id);
        }
    },
    init: function () {
        if (showImageTab) {
            iv1 = $("#imageMain").iviewer({
                src: ''/*, zoom: 100*/
            });

            $.imageViewer.constructImageViewer();
        }
        else {
            var target = $('a[data-bs-toggle="tab"].active').attr("href"); /* get activated tab*/
            $.messageviewer.resetTab(target);
        }
        
        /*Button Handler*/
        $.messageviewer.onPrintActionChange('.dropdown-print');
        $.messageviewer.onSaveActionChange('.dropdown-save');
        $.messageviewer.performMsgActionHandler('.btn-msgviewer-action');
        $.messageviewer.performPrintNetworkActionHandler('button[data-role="print-network"]');
        $.messageviewer.tabButtonClickHandler('a[data-bs-toggle="tab"]');
        $.messageviewer.transcListDDLOnChange('#TranscList');

        refreshLocation = Number($('#RefreshLocation').val());
        
        $.userSelectionMsgViewer.init();
        
        $(window).resize(function () {
            if (showImageTab) {
                /* Set image back to central */
                setTimeout(function () {
                    $("#imageMain").iviewer('update');
                }, 300);
            }

			if ($(window).width() <= 991) {
				$('.TabMsgViewer .tabs-vertical').addClass("collapseTab");
				$(".tabs-vertical.collapseTab > #navTabCollapse > a").attr("title", $msgViewer.actionTitle.showMore);
			}
            else
			{
				$('.TabMsgViewer .tabs-vertical').removeClass("collapseTab");
				$(".tabs-vertical > #navTabCollapse > a").attr("title", $msgViewer.actionTitle.showLess);
			}
                
        });

        var statusColor = $('#TxtStatus').css("background-color");
        $('.badge-text').css("color", statusColor);
        $('#msgStatus').css("border-color", statusColor);
    },

    markAsRead: function (id) {
        var trId = 'tr[data-id="' + id + '"]';

        if ($(trId).hasClass('Row-Readable-False')) {
            $(trId).removeClass('Row-Readable-False');

            var newMessageCount = parseInt($(".displayTotal1").html()) - 1;
            $(".displayTotal1").text(newMessageCount);
        }
    },
    /*Btn Action*/
    onPrintActionChange: function (e) {
        $(e).on('click', function (x, y) {
            var getDataCommand = $(this).data();

            $.each(getDataCommand, function (key, value) {
                $("#btn-print-viewer").attr("data-" + key, value);
            });
            $("#btn-print-viewer .btn-label-text").text(getDataCommand["type"]);
            $("#btn-print-viewer .btn-label i").removeClass($("#btn-print-viewer .btn-label i").attr("class"));
            $("#btn-print-viewer .btn-label i").addClass(getDataCommand["typeicon"]);
        });
    },
    onSaveActionChange: function (e) {
        $(e).on('click', function (x, y) {
            var getDataCommand = $(this).data();

            $.each(getDataCommand, function (key, value) {
                $("#btn-save-viewer").attr("data-" + key, value);
            });
            $("#btn-save-viewer .btn-label-text").text(getDataCommand["type"]);
            $("#btn-save-viewer .btn-label i").removeClass($("#btn-save-viewer .btn-label i").attr("class"));
            $("#btn-save-viewer .btn-label i").addClass(getDataCommand["typeicon"]);
        });
    },
    performMsgActionHandler: function (e) {
        $(e).on('click', function () {
            var btnTemp = this;

            command = $(this).attr('data-command').toString();

            if (command == '111') { /*Assign*/
                $.messageviewer.showDialog(1);
            } else if (command == '103') { /*forward to user*/
                $.messageviewer.showDialog(2);
            } else if (command == '115') { /*forward*/
                $.imageViewer.getSelectedImage();
                $.messageviewer.showSendMsgWin('f');
            } else if (command == '104') { /*Resend*/
                $.imageViewer.getSelectedImage();
                $.messageviewer.showSendMsgWin('r');
            } else if (command == '110') { /*PrintNetwork*/
                $.imageViewer.getSelectedImage();
                if ($.messageviewer.noneSelected() == 'false') {
                    if ($('#saveAction button.btn-msgviewer-save').attr("data-print") == "false") {
                        swal($globalMessages.swal.warningTitle, $msgViewer.message.printWarning, "warning");
                    }
                    else {
                        $.messageviewer.showDialog(3);
                    }
                }

            } else if (command == '109') { /*PrintLocal*/
                $.imageViewer.getSelectedImage();
                if ($.messageviewer.noneSelected() == 'false') {
                    if ($('#saveAction button.btn-msgviewer-save').attr("data-print") == "false") {
                        swal($globalMessages.swal.warningTitle, $msgViewer.message.printWarning, "warning");
                    }
                    else {
                        $.messageviewer.printLocalAction();
                    }
                }

            } else if (command == '116') { /*Save as PDF*/
                /*handle at btn-saveas click */
                $.imageViewer.getSelectedImage();
                if ($.messageviewer.noneSelected() == 'false') {
                    if ($('#saveAction button.btn-msgviewer-save').attr("data-download") == "false") {
                        swal($globalMessages.swal.warningTitle, $msgViewer.message.saveWarning, "warning");
                    }
                    else {
                        $.messageviewer.saveImageAs('PDF');
                    }
                    
                }
            } else if (command == '117') { /*Save as TIF*/
                /*handle at btn-saveas click */
                $.imageViewer.getSelectedImage();
                if ($.messageviewer.noneSelected() == 'false') {
                    if ($('#saveAction button.btn-msgviewer-save').attr("data-download") == "false") {
                        swal($globalMessages.swal.warningTitle, $msgViewer.message.saveWarning, "warning");
                    }
                    else {
                        $.messageviewer.saveImageAs('TIF');
                    }
                }

            } else if (command === '125') {
                /* handle split message get deselected */
                var $pages = $('#PageCount').val();
                if ($pages !== '' && parseInt($pages) > 1) {
                    $('#splitPagesmsgviewer').text($msgViewer.pages + ' ' + $pages);
                    $('#splitInputmsgviewer').val('1-' + $pages);
                    
                    $('#splitmsgviewermodal').modal('show');
                } else {
                    swal($globalMessages.swal.error.title, $msgViewer.unable, "error");
                }
            } else {
                var confirmationMsg = $(this).data('confirmationmsg');
                if (confirmationMsg) {
                    swal({
                        title: "",
                        text: confirmationMsg,
                        type: "info",
                        showCancelButton: true,
                        reverseButtons: true
                    }, function () {
                        $.messageviewer.performMsgAction(command, null, btnTemp);
                    });
                }
                else {
                    $.messageviewer.performMsgAction(command, null, btnTemp);
                }
            }
            $(this).blur();
        });
    },
    onAnnotateClickHandler: function (e) {
        $(e).click(function () {
            var $pages = $('#PageCount').val();
            if ($pages == '' || parseInt($pages) == 0) {
                swal($globalMessages.swal.error.title, $globalMessages.annotation.notAvailable, "error");
            }
            else {
                $.shared.annotateDocument();
            }
        });
    },
    tabButtonClickHandler: function (e) {
        $(e).on('shown.bs.tab', function (h) {
            var target = $(h.target).attr("href"); /* activated tab*/
            $.messageviewer.resetTab(target);
        });
    },
    transcListDDLOnChange: function (e) {
        $(e).on('change', function (f) {
            if ($("#TranscList option:selected").val() === 'loadmore') {

                fxcRequest.get('/Common/MessageViewer/GetPageTransRecords',
                    {
                        "TransPage": $('#TransXPage').val(),
                        "TransSize": $('#TransXSize').val(),
                        "MessageId": $('#MsgID').val()

                    }, function (data) {

                        $('#TranscList option[value="loadmore"]').remove();
                        var transJson = JSON.parse($('#TransactionDetailsList').val());

                        $.each(data.TransactionDetails, function (index, value) {
                            var notiAlert = value.TransactionDetails.IsFailedNotification === true ? '1' : '0';
                            $('#TranscList').append("<option value='" + value.TransactionDetails.TransactionID + "' data-notialert='" + notiAlert + "'>" + value.TransactionDetails.RecipientName + "(" + value.TransactionDetails.MessageDisplayAddress + ")" + "</option>")
                            transJson.push(value);
                        });
                        if ($('#TransXListTotal').val() > (data.TransPage * data.TransSize)) {
                             $('#TranscList').append("<option value='loadmore' data-notialert='0'>** Load More **</option>");
                        }
                        $('#TransXPage').val(data.TransPage);
                        $('#TransXSize').val(data.TransSize);
                        $('#TransactionDetailsList').val(JSON.stringify(transJson));
                        swal.close();
                    }, function () { }, true, null, function (serverError) {
                    });

            } else {
                $("#TranscList-Text").val($("#TranscList option:selected").text());
                $("#TranscList-Value").val($("#TranscList option:selected").val());

                $.notification.initAlert();

                $('#TranscList').attr("title", $("#TranscList-Text").val());
                _detailtransaction = false;
                notificationTab = false;
                var target = $('#MsgViewer-Tab li a.active').attr("href"); /* activated tab*/
                $.messageviewer.resetTab(target);
            }
        });
    },

    /*Logic*/
    getDownloadType: function (e) {
        var val = $('#btn-save-viewer').attr("data-type");
        return val;
    },
    getXsactData: function (isMsg) {
        var returnVal = '';
        if (isMsg) {
            returnVal = $('#MsgID').val() + '|' + $('#UserMsgID').val();
        }
        else {
            var id = $("#TranscList-Value").val();
            returnVal = id + '|' + $('#MsgID').val();
        }
        return returnVal;
    },
    isMessage: function (e) {
        if ($("#TranscList-Value").val() == $('#MsgID').val())
            return true;
        else
            return false;
    },
	noneSelected: function (e) {		
        /*throw error when no image thumbnail selected*/
        var imageViewerEnabled = $('#hfImageViewerEnabled').val();/*value from config*/
        if (imageViewerEnabled == 'false') {
            return 'false';
        }
        else {
			
            var val = $('#hfNoneSelected').val();/*value from thumbnail selection*/

            if (val === 'true' && Number($('#PageCount').val()) === 0) {
				swal($globalMessages.swal.warningTitle, $msgViewer.message.noImage, "warning");
            }

            if (val == 'true' && Number($('#PageCount').val()) > 0) {
                swal($globalMessages.swal.warningTitle, $msgViewer.message.minPage, "warning");
            }
        }
        return val;
    },
    resetTab: function (target) {
        switch (target) {
            case "#DetailsTab":
                if (true) { /* !detailTab */
					$.detail.initForm();
                    detailTab = true;
                }                
                break;
            case "#TransactionTab":
                if (true) { /* !_detailtransaction */
                    $.detail.getTransaction();
                    _detailtransaction = true;
                }
                break;
			case "#DelegateeHistory":
                if (true) { /* !delegateeHistoryTab */
                    $.delegatee.initGridDelegateeHistory();
					delegateeHistoryTab = true;
				}
				break;
            case "#NotificationTab":
                if (true) { /* !notificationTab */
                    $.notification.initForm();
                    notificationTab = true;
                }
                break;
            case "#HistoryTab":
                if (true) { /* !historyTab */
                    $.history.initForm();
                    historyTab = true;
                }
                break;
            case "#TrackingTab":
                if (true) { /* !trackingTab */
                    $.tracking.initForm();
                    trackingTab = true;
                }
                break;
            case "#ApprovalTab":
                if (true) { /* !approvalTab */
                    $.approval.initForm();
                    approvalTab = true;
                }
                break;
            case "#ImageTab":
                if (!mvPrivacy) {
                    var messageId = $('#MsgID').val()
                        , transId = $("#TranscList-Value").val()
                        , isXsact = '1';
                    fxcRequest.get('/Common/MessageViewer/GetFrameCount',
                        {
                            "XsactId": transId,
                            "IsXsact": isXsact
                        }, function (data) {
                            $('#PageCount').val(Number(data.Count));
                            $.imageViewer.showBtnAnnotation();

                            /*Construct Main Image*/
                            $.imageViewer.displayMainImage({
                                messageId: messageId,
                                transactId: transId,
                                page: '0',
                                format: 'image',
                                isXsact: isXsact,
                                pageNumber: data.Count
                            });
                        }, function () { }, false, null, function (serverError) {
                            $.imageViewer.noImage(true);
                    });
                }
                else {
                    $.imageViewer.noImage(true, $msgViewer.message.restricted);
                }
                break;
            default:
                break;
        }
    },
    showDialog: function (type) {

        switch (type) {
            case 1:
                /*Assign*/
                $("#userSelection-MsgViewer").text("Assign to User(s)");
                $("#BtnSaveuserSelection-MsgViewer").val("Assign");
                $("#userSelection-MsgViewer-modal").modal('show');
                $.userSelectionMsgViewer.reset();
                return false;
            case 2:
                /*Forward*/
                $("#userSelection-MsgViewer").text("Forward to User(s)");
                $("#BtnSaveuserSelection-MsgViewer").val("Forward");
                $("#userSelection-MsgViewer-modal").modal('show');
                $.userSelectionMsgViewer.reset();
                return false;
            case 3:
                $.messageviewer.loadNetworkPrinter();
                break;
            case 4:
                break;
            default:
                break;
        }
    },
    showSendMsgWin: function (rfType) {
        if ($.messageviewer.noneSelected() == 'false') {
            var url = '/User/Message?rf=' + rfType + '&umid=' + $('#UserMsgID').val() + '&mid='
                + $('#MsgID').val();

            url = url + '&delegatorID=' + $('#DelegatorID').val() + '&delgProID=' + $('#DelgProID').val();

            var des = $('#hfDeselectedPages').val();
            if (des)
                url = url + '&des=' + des;

            $.messageviewer.showWin(url, '800', '580', rfType, 'yes');
        }
    },
    showSuccessStatus: function (command, e) {
        if (command != null && e != null) {
            var successType = $(e).data('successtype');
			var successMsg = $(e).data('successmsg');
			var autoClose = $(e).data('autoclose') != null && $(e).data('autoclose').toLowerCase() == "true" ? true : false;
            
            switch (successType) {
                case "Toast":
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: successMsg,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    break;
                case "Swal":
					swal($globalMessages.swal.success.title, successMsg, "success");

                    break;
                default:

			}
        }
    },
    showWin: function (winUrl, width, height, winName, resize) {
        var winPopup;
        var url = winUrl;
        var name = winName;

        var features = 'width=' + width + ',height=' + height + ',resizable=' + resize + ',scrollbars=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no';
        winPopup = window.open(url, name, features);
        if (name == "PrintLocalPDF") {
            winPopup.print();
        }
        winPopup.focus();
    },

    /*Post or Get Function*/
    loadNetworkPrinter: function () {
        fxcRequest.get('/User/MsgIndex/GetNetworkPrinterDataSource'
            , null
            , function (data) {
                $.sectionproperties.selectGenerator('ddlNetPrinter', data.NetworkPrinter.NetworkPrinterConfigType.Source, data.NetworkPrinter.NetworkPrinterConfigType.Value, 0);
                $('#ddlPaperSize').html(data.NetworkPrinter.XmlData);

                $('#printNetwork-modal').modal('show');
            }
            , function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }
        );
    },
    performMsgAction: function (command, selectedMoveFolder) {
        var e = $(".btn-msgviewer-action[data-command='" + command + "']");
        var successType = $(e).data('successtype');
        var successMsg = $(e).data('successmsg');

        var data = {
            "ID": $('#MsgID').val(),
            "UserMsgID": $('#UserMsgID').val(),
            "AppReqID": $('#ApprovalReqID').val(),
            "FolderID": $('#FolderId').val(),
            "DelgID": $('#DelegatorID').val(),
            "DelgPro": $('#DelgProID').val()
        };

        data["TransactID"] = $("#TranscList option:selected").val();
        data["Command"] = command;
        data["IsNotify"] = $('#IsNotify').val();
        data["TxtApprovalReply"] = $('#TxtApprovalReply').val();
        data["SelectedUser"] = $selectedUser;

        var postLoader = false;

        switch (successType) {
            case "Toast":
                postLoader = false;
                break;
            case "Swal":
                postLoader = true;
                break;
            default:
        }
        fxcRequest.post('/Common/MessageViewer/PerformMsgAction'
            , data
            , function (data) {

                $.messageviewer.showSuccessStatus(command, e);
                
                /*
                 * this line will handle the signalR message workflow for notification
                 * */
                switch (command) {
                    case 100:/*move to trash*/
                    case 102:/*delete permanently*/
                        window.close();
                        break;
                    case 103:
                        $("#userSelection-MsgViewer-modal").modal("hide");
                        break;
                    case 111:
                        $("#userSelection-MsgViewer-modal").modal("hide");
                        if (fxcMessageHub.server !== undefined) {
                            fxcMessageHub.server.onBulkAssigned({
                                Users: $selectedUser,
                                Command: command
                            });
                        }
                        break;
                    case 110: /* Not used */
                        $('#printNetwork-modal').modal('hide');
                        break;
				}
				
                /*update grid*/
                 if (fxcMessageHub.server !== undefined) {
                    var resfreshModel = { "RefreshLocation": refreshLocation };
                    fxcMessageHub.server.onRefresh(resfreshModel);
                }
                
            }
            , function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }, postLoader);
    },
    performPrintNetworkActionHandler: function (e) {
        $(e).on('click', function () {
            var $selectedMsg = [];
            var msg = { 'MessageID': $('#MsgID').val(), 'TransactID': $("#TranscList-Value").val() };
            $selectedMsg.push(msg);

            fxcRequest.post('/User/UserCommon/PrintNetwork',
                {
                    "SelectedMsg": $selectedMsg,
                    "DelegatorID": $('#DelegatorID').val(),
                    "DelgProID": $('#DelgProID').val(),
                    'PrintNetwork': {
                        'selectedNetPrinter': $('#ddlNetPrinter').val(),
                        'PaperSize': $('#ddlPaperSize').val(),
                        'BannerPg': $('#ddlBannerPg').val(),
                        'IsMsg': $.messageviewer.isMessage(),
                        'Des': $('#hfDeselectedPages').val()
                    }
                }
                , function (data) {
                }, null, false);

            /* Always return successful */
            $('#printNetwork-modal').modal('hide');
            swal($globalMessages.swal.success.title, $msgViewer.message.beginPrintNetwork, 'success');
        });
    },
    printLocalAction: function (e) {
        var isMsg = $.messageviewer.isMessage();
        var type = $.messageviewer.getDownloadType();

        var param = {
            'ismsg': isMsg ? '1' : '0',
            'type': type,
            'data': $.messageviewer.getXsactData(isMsg),
            'des': $('#hfDeselectedPages').val(),
            'delg': $('#DelegatorID').val(),
            'pro': $('#DelgProID').val()
        }
        var url = '/Print/Local?' + new URLSearchParams(param).toString();

        $.messageviewer.showWin(url, 400, 600, 'PrintLocal' + type, 'yes');
    },
    saveImageAs: function (type) {
        var isMsg = $.messageviewer.isMessage();
        var param = {
            'ismsg': isMsg ? '1' : '0',
            'type': type,
            'data': $.messageviewer.getXsactData(isMsg),
            'des': $('#hfDeselectedPages').val(),
            'delg': $('#DelegatorID').val(),
            'pro': $('#DelgProID').val()
        }
        var url = '/Save/Image?' + new URLSearchParams(param).toString();
        $.messageviewer.showWin(url, 400, 600, 'SaveAs', 'yes');
    },
    showMessageViewerMessageQueue: function (dataItem) {

        messageID = dataItem.MessageID;
        mid = dataItem.MID;
        approvalReqID = '';
        userMsgID = dataItem.UserMsgID;
        folderName = dataItem.rowAdditionalObj.IsMsgSchedule === 'true' ? 'Schedule' : 'Queue';
        folderID = 0;
        delegatorID = '';
        delgProID = '';

        /* Store data via html5 web storage */
        var data = messageID + ';' + approvalReqID + ';' + userMsgID + ';' + folderName + ';' + folderID +
            ';' + delegatorID + ';' + delgProID;

        localStorage.setItem('Data_' + messageID, data);

        /*Additional row data*/
        var extra = JSON.stringify(dataItem.rowAdditionalObj);
        localStorage.setItem('Data_Extra' + messageID, extra);

        var url = "";

        if (dataItem.rowAdditionalObj.HideImageTab) {
            url = "/Message/Detail/" + mid + "/" + userMsgID + "/" + folderID + "/" + folderName + "/";
        }
        else {
            url = "/Message/Viewer/" + mid + "/" + userMsgID + "/" + folderID + "/" + folderName + "/";
        }

        if (dataItem.rowAdditionalObj.RefreshLocation) {
            url += dataItem.rowAdditionalObj.RefreshLocation + "/";
        }

        var winPopup;

		var w = 1200, h = 750;
        var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
        var dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;

        var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

        var left = ((width / 2) - (w / 2)) + dualScreenLeft;
        var top = ((height / 2) - (h / 2)) + dualScreenTop;

        var features = 'width=' + w + ',height=' + h + ',resizable=' + true + ',scrollbars=no,' +
            'toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no' +
            ', top=' + top + ', left=' + left;
		var name = 'form-message-viewer_' + mid + "_" + userMsgID;

        winPopup = window.open(url, name, features);
        winPopup.focus();
    }
};

$.shared = {

    /*Btn Action*/
    toggleChangedEventHandler: function (event) {
        var divMoreID = $(event).attr("data-toggle");
        var children = $(event).children();
        var _span = $(children[0]);
        var _i = $(children[1]);

        if ($("#" + divMoreID).hasClass("hide")) {
            /*true*/
            $("#" + divMoreID).removeClass("hide");
			_span.text($msgViewer.grid.viewLess);
            _i.addClass("chevron-double-up");
        }
        else {
            /*false*/
            $("#" + divMoreID).addClass("hide");
			_span.text($msgViewer.grid.viewMore);
            _i.removeClass("chevron-double-up");
        }
    },

    /*Shared Function between Transaction Tab & Notifcation Tab*/
    getAttemptList: function (transactionId, targetDiv) {
        /*Load Attempt List*/
        $(targetDiv).html("");
        $(targetDiv).addClass("divLoading");
        fxcRequest.post('/Common/MessageViewer/GetAttemptView',
            {
                "TransactionID": transactionId
            },
            function (data, textStatus, jqXHR) {
				$(targetDiv).html(data);

				$.userSelectionMsgViewer.initPopover($(targetDiv));

                /* Expand the only attempt under Transaction */
                if ($(targetDiv).parents('#TransactionTab').length) {                    
                    var attempt = $(targetDiv).find(".attempt");
                    $('#totalTransAttempt').text(attempt.length);

                    if (attempt.length == 1) {
                        attempt.find('button').click();
                    }
                }

                $(targetDiv).removeClass("divLoading");
            }, function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }, false);
    },
    
    getWindowFeatures: function () {
        var w = 1500, h = 840;
        var dualScreenLeft = window.screenLeft ? window.screenLeft : window.screenX;
        var dualScreenTop = window.screenTop ? window.screenTop : window.screenY;
        var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
        var left = ((width / 2) - (w / 2)) + dualScreenLeft;
        var top = ((height / 2) - (h / 2)) + dualScreenTop;
        var features = 'width=' + w + ',height=' + h + ',resizable=' + true + ',scrollbars=no,' +
            'toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no' +
            ', top=' + top + ', left=' + left;
        return features;
    },
    annotateDocument: function () {
        var msgId = $('#MsgID').val();
        var xsactId = $("#TranscList-Value").val();
        var fileName = $('#TxtMsgNo').val();
        var delgId = $('#DelegatorID').val();

        var url = '/annotation/msgviewer/' + fileName + '/' + msgId + '/' + xsactId + '/' + delgId;

        window.open(url, 'msg-viewer-annotation', $.shared.getWindowFeatures());
    },
    annotationWindowCallback: function () {
        if (showImageTab) {
            $.imageViewer.constructImageViewer();
        }
        else {
            var target = $('a[data-bs-toggle="tab"].active').attr("href"); /* get activated tab*/
            $.messageviewer.resetTab(target);
        }
        
    }
};