﻿

/* Construct Model Helper
- Please make sure both Entity name property and input/Dropdown id are the same before call this method
- The return value will only be in string datatype.
*/
$commonModelMapping = {

    constructModel: function (formId) {
        var arr;

        $.each($("#" + formId + " input"), function (i, v) {

            if (v.type === 'text' || v.type === 'password' || v.type === 'hidden')
                arr[v.id] = v.value;

            if (v.type === 'checkbox')
                arr[v.id] = $(this).prop("checked");
        });

        $.each($("#" + formId + " select"), function (i, v) {
            arr[v.id] = $(this).val();
        });

        return arr;
    }
};

/* Forward to User Common Modal
- Assign Message will be using similiar script as Forward to User
- 103 => Forward to user, 111 => Assign Message
*/
var forwardUserValidation = function (e) {

    $('#formSubmit_' + e + '').validate({
        rules: {
            SelectedUserList: {
                multiselectrequired: true
            }
        },
        messages: {
            SelectedUserList: {
                multiselectrequired: $.validator.messages.userSelection
            }
        },
        submitHandler: function (form) {

            var modalId = $("#ActiveModal").val();

            if ($("#" + modalId + "_SelectedUserList option").length > 0) {
                var arrUser = new Array();

                var selectedUserList = $("#" + modalId + "_SelectedUserList option");

                $.each(selectedUserList, function (i, e) {

                    var value = e.value;
                    var text = e.text;
                    arrUser[i] = e.value;

                });

                var successMsg;
                switch ($command) {
                    case 103:
                        successMsg = $areaResources.swal.msgsForwardedSuccess;
                        break;
                    case 111:
                        successMsg = $areaResources.swal.msgAssignedSuccess;
                        break;
                    default:
                }

                $.forwardtouser.data = jQuery.data($.forwardtouser, 'selecteduser', arrUser);
                $.forwardtouser.data = jQuery.data($.forwardtouser, 'successtype', 'Swal');
                $.forwardtouser.data = jQuery.data($.forwardtouser, 'successmsg', successMsg);

                if ($.forwardtouser.data !== undefined && $postFunction !== undefined
                    && $command !== undefined) {
                    $postFunction.call(this, $command, null, $.forwardtouser);
                }
            }
            else {
                swal($globalMessages.swal.warningTitle, $.validator.messages.userSelection, "warning");
                return false;
            }
        }
    });
};

var $arrUser, $postFunction, $command, $treeForward, $treeAssign;
$.forwardtouser = {

    init: function (e, f, g) {

        $postFunction = e;
        var modalId = f;

        if (g === 103) {
            var obj = {};
            obj.postSelectFn = $.forwardtouser.getForwardUserActiveUserList;
            obj.reselectChild = true;
            obj.selectFirstNode = true;
            obj.lazyLoading = true;
            obj.declareType = "textbox";

            $treeForward = $treeId = treeview.init('' + modalId + '_DmnTree', '' + modalId + '_DmnTree-name', '' + modalId + '_DmnTree-id', obj);
        }
        else {
            var obj2 = {};
            obj2.postSelectFn = $.forwardtouser.getAssignMsgActiveUserList;
            obj2.reselectChild = true;
            obj2.selectFirstNode = true;
            obj2.lazyLoading = true;
            obj2.declareType = "textbox";

            $treeAssign = treeview.init('' + modalId + '_DmnTree', '' + modalId + '_DmnTree-name', '' + modalId + '_DmnTree-id', obj2);
        }

        forwardUserValidation(modalId);
    },
    forwardButtonClickHandler: function (e) {
        $(e).on('click', function () {

            var modalId = $("#ActiveModal").val();

            if (e[0].innerText === "Forward")
                $command = 103;
            else
                $command = 111;

            $('#formSubmit_' + modalId + '').submit();
        });
    },
    searchButtonClickHandler: function (e) {

        $(e).on('click', function (event) {

            var modalId = $("#ActiveModal").val();
            var activeUserlistBox = $("#" + modalId + "_ActiveUserList").data("kendoListBox");
            var selectedUserlistBox = $("#" + modalId + "_SelectedUserList").data("kendoListBox");
            var domainId = $("#" + modalId + "_DmnTree-id").val();

            if (activeUserlistBox !== undefined && selectedUserlistBox !== undefined) {

                if (modalId === "assign-modal")
                    $.forwardtouser.getAssignMsgActiveUserList(domainId);
                else
                    $.forwardtouser.getForwardUserActiveUserList(domainId);
            }
        });
    },
    searchHandler: function (e) {
        $(e).keypress(function (event) {

            if (event.which === 13) {
                event.preventDefault();

                var modalId = $("#ActiveModal").val();

                var activeUserlistBox = $("#" + modalId + "_ActiveUserList").data("kendoListBox");
                var selectedUserlistBox = $("#" + modalId + "_SelectedUserList").data("kendoListBox");
                var domainId = $("#" + modalId + "_DmnTree-id").val();

                if (activeUserlistBox !== undefined && selectedUserlistBox !== undefined) {
                    if (modalId === "assign-modal")
                        $.forwardtouser.getAssignMsgActiveUserList(domainId);
                    else
                        $.forwardtouser.getForwardUserActiveUserList(domainId);
                }
            }
        });
    },
    resetButtonClickHandler: function (e) {
        $(e).on('click', function () {

            $.forwardtouser.resetfields();
        });
    },
    getForwardUserActiveUserList: function (e) {

        var name = $treeForward.getDataById(e).text;
        var id = $treeForward.getDataById(e).id;

        $("#forward-modal_DmnTree-ddl").val(name);
        $("#forward_DmnTree-id").val(id);
        $("#forward_DmnTree-name").val(name);

        fxcRequest.get('/Common/PopulateActiveUser',
            {
                DomainID: e,
                SearchText: $('#formSubmit_forward-modal input[data-role="search-active-user"]').val()
            },
            function (data) {
                var activeUserlistBox = $("#forward-modal_ActiveUserList").data("kendoListBox");
                var selectedUserlistBox = $("#forward-modal_SelectedUserList").data("kendoListBox");

                if (activeUserlistBox !== undefined && selectedUserlistBox !== undefined) {
                    activeUserlistBox.remove(activeUserlistBox.items());
                    selectedUserlistBox.remove(selectedUserlistBox.items());

                    var activeDataSource = new kendo.data.DataSource({
                        data: data.ActiveUserModel.ActiveUserList.Source
                    });

                    var selectedDataSource = new kendo.data.DataSource({
                        data: data.ActiveUserModel.SelectedUserList.Source
                    });

                    activeUserlistBox.setDataSource(activeDataSource);
                    selectedUserlistBox.setDataSource(selectedDataSource);
                }
                else {
                    /* Forward To User */
                    $("#forward-modal_ActiveUserList").kendoListBox({
                        selectable: "multiple",
                        dropSources: ["forward-modal_SelectedUserList"],
                        dataValueField: "Value",
                        dataTextField: "Text",
                        dataSource: {
                            data: data.ActiveUserModel.ActiveUserList.Source
                        },
                        draggable: {
                            enabled: true
                        },
                        connectWith: "forward-modal_SelectedUserList",
                        toolbar: {
                            tools: ["transferTo", "transferFrom", "transferAllTo", "transferAllFrom"]
                        },
                        drop: function (e) {

                        },
                        dataBound: function () {
                            this.selectable.userEvents._events.start = null;
                            this.selectable.userEvents._events.move = null;
                            $("#forward_ActiveUserList").kendoDraggable({
                                filter: ".draggable",
                                hint: function (element) {
                                    return element.clone();
                                }
                            });
                        }
                    });
                    $.forwardtouser.customizeHeight($("#forward-modal_ActiveUserList").parent(".k-listbox"), true);

                    $("#forward-modal_SelectedUserList").kendoListBox({
                        selectable: "multiple",
                        dropSources: ["forward-modal_ActiveUserList"],
                        draggable: {
                            enabled: true
                        },
                        dataValueField: "Value",
                        dataTextField: "Text",
                        dataSource: {
                            data: data.ActiveUserModel.SelectedUserList.Source
                        },
                        connectWith: "forward-modal_ActiveUserList",
                        drop: function (e) {

                        },
                        dataBound: function () {
                            this.selectable.userEvents._events.start = null;
                            this.selectable.userEvents._events.move = null;
                            $("#forward-modal_SelectedUserList").kendoDraggable({
                                filter: ".draggable",
                                hint: function (element) {
                                    return element.clone();
                                }
                            });
                        }
                    });
                    $.forwardtouser.customizeHeight($("#forward-modal_SelectedUserList").parent(".k-listbox"), true);
                }
            },
            function (error) {
                swal('ERROR', 'error on load', 'error');
            });
    },
    getAssignMsgActiveUserList: function (e) {

        var name = $treeAssign.getDataById(e).text;
        var id = $treeAssign.getDataById(e).id;

        $("#assign-modal_DmnTree-ddl").val(name);
        $("#assign-modal_DmnTree-id").val(id);
        $("#assign-modal_DmnTree-name").val(name);

        fxcRequest.get('/Common/PopulateActiveUser',
            {
                DomainID: e,
                SearchText: $('#formSubmit_assign-modal input[data-role="search-active-user"]').val()
            },
            function (data) {

                var activeUserlistBox = $("#assign-modal_ActiveUserList").data("kendoListBox");
                var selectedUserlistBox = $("#assign-modal_SelectedUserList").data("kendoListBox");

                if (activeUserlistBox !== undefined && selectedUserlistBox !== undefined) {
                    activeUserlistBox.remove(activeUserlistBox.items());
                    selectedUserlistBox.remove(selectedUserlistBox.items());

                    var activeDataSource = new kendo.data.DataSource({
                        data: data.ActiveUserModel.ActiveUserList.Source
                    });

                    var selectedDataSource = new kendo.data.DataSource({
                        data: data.ActiveUserModel.SelectedUserList.Source
                    });

                    activeUserlistBox.setDataSource(activeDataSource);
                    selectedUserlistBox.setDataSource(selectedDataSource);

                }
                else {
                    $("#assign-modal_ActiveUserList").kendoListBox({
                        selectable: "multiple",
                        dropSources: ["assign-modal_SelectedUserList"],
                        dataValueField: "Value",
                        dataTextField: "Text",
                        dataSource: {
                            data: data.ActiveUserModel.ActiveUserList.Source
                        },
                        draggable: {
                            enabled: true
                        },
                        connectWith: "assign-modal_SelectedUserList",
                        toolbar: {
                            tools: ["transferTo", "transferFrom", "transferAllTo", "transferAllFrom"]
                        },
                        drop: function (e) {

                        },
                        dataBound: function () {
                            this.selectable.userEvents._events.start = null;
                            this.selectable.userEvents._events.move = null;
                            $("#assign-modal_ActiveUserList").kendoDraggable({
                                filter: ".draggable",
                                hint: function (element) {
                                    return element.clone();
                                }
                            });
                        }
                    });
                    $.forwardtouser.customizeHeight($("#assign-modal_ActiveUserList").parent(".k-listbox"), true);

                    $("#assign-modal_SelectedUserList").kendoListBox({
                        selectable: "multiple",
                        dropSources: ["assign-modal_ActiveUserList"],
                        draggable: {
                            enabled: true
                        },
                        dataValueField: "Value",
                        dataTextField: "Text",
                        dataSource: {
                            data: data.ActiveUserModel.SelectedUserList.Source
                        },
                        connectWith: "assign-modal_ActiveUserList",
                        drop: function (e) {

                        },
                        dataBound: function () {
                            this.selectable.userEvents._events.start = null;
                            this.selectable.userEvents._events.move = null;
                            $("#assign-modal_SelectedUserList").kendoDraggable({
                                filter: ".draggable",
                                hint: function (element) {
                                    return element.clone();
                                }
                            });
                        }
                    });
                    $.forwardtouser.customizeHeight($("#assign-modal_SelectedUserList").parent(".k-listbox"), true);
                }
            },
            function (error) {
                swal('ERROR', 'error on load', 'error');
            });
    },
    resetfields: function () {

        var modalId = $("#ActiveModal").val();

        $('#formSubmit_' + modalId + '').validate().resetForm();
        $('input[data-role="search-active-user"]').val('');
        var activeUserlistBox = $("#" + modalId + "_ActiveUserList").data("kendoListBox");
        var selectedUserlistBox = $("#" + modalId + "_SelectedUserList").data("kendoListBox");
        var domainId = $("#" + modalId + "_DmnTree-id").val();

        if (activeUserlistBox !== undefined && selectedUserlistBox !== undefined) {
            if (modalId === "assign-modal")
                $.forwardtouser.getAssignMsgActiveUserList(domainId);
            else
                $.forwardtouser.getForwardUserActiveUserList(domainId);

        }
    },
    customizeHeight: function (e) {
        if ($(e).is(':visible')) {
            var rowHeight = $(window).height();
            var topHeight = $(e).offset().top;
            var assumeBottomHeight = $(e).closest(".modal").length > 0 ? 150 : 100;

            var finalHeight = rowHeight - topHeight - assumeBottomHeight;

            /*Check if other listbox same row exist. If Yes save same height*/
            var getCurrentId = "";

            if ($(e).find("[data-role='listbox']").length) {
                getCurrentId = $(e).find("[data-role='listbox']")[0].id;
            }
            if ($(e).closest(".row").find(".k-listbox").length > 1) {
                /*check if currentID is first id in listbox*/
                var listBoxFirstID = $($(e).closest(".row").find(".k-listbox")[0]).find("[data-role='listbox']")[0].id;
                if (listBoxFirstID != getCurrentId) {
                    finalHeight = $($(e).closest(".row").find(".k-listbox")[0]).height();
                }
            }

            finalHeight = finalHeight > 200 ? finalHeight : 200;

            $(e).css("height", finalHeight);
        }
    }
};

/*For json data with ConfigType model*/
/*Bind json data to form with same id-key*/
(function ($) {
    $.fn.BindJson = function (fieldData, prefix, suffix) {

        var key = [],
            ctl = null,
            isTextField = false,
            fill = "";
        for (key in fieldData) {
            if (fieldData.hasOwnProperty(key)) {
                ctl = $(prefix + key + suffix, this);
                fill = fieldData[key];
                if (ctl.length != 0 && fill != null) {
                    $(ctl).each(function () {

                        var control = $(this);
                        var tag = control[0].tagName;
						var type = control.prop('type');
						
                        var parentClass = control[0].parentNode.className;

                        var val = fill.Value;
                        var source = fill.Source;
                        var isSet = fill.IsSet;

                        var boolVal = val == "1" || val == "true" || val == true || val == "PDF";
                        var isSetBoolVal = isSet == "1" || isSet == "true" || isSet == true;

                        isTextField = (control.is("DIV") || control.is("SPAN") || control.is("LABEL"));

                        if (control.hasClass("userSelection") && val.length > 0) {
                            control.tagsinput({
                                itemValue: 'id',  /* this will be used to set id of tag*/
                                itemText: 'label', /* this will be used to set text of tag*/
                            });

                            if (val.lastIndexOf(';') == val.length - 1) {
                                val = val.substring(0, val.lastIndexOf(';'));
                            }
                            var selectedItem = val == "" ? [] : val.split(';');

                            /*if the source is null or empty*/
                            source = source == null || source.length == 0 ? val : source;

                            var selectedSource = source == "" ? [] : source.split(';');

                            control.tagsinput('removeAll');

                            $.each(selectedItem, function (index, obj) {
                                control.tagsinput('add', { id: obj, label: selectedSource[index] });
                            });
                        }
                        else if (isTextField) {
                            var current = control.prop('disabled');
                            control.prop('disabled', false);
                            control.text(val);
                            control.prop('disabled', current);

                        } else if (tag == 'INPUT') {

                            if (type == 'checkbox') {
								
                                var selectBool = suffix == "_IsSet" ? isSetBoolVal : boolVal;

								if (parentClass == "bootstrap-switch-container") {
                                    var currentBsSwitch = control.bootstrapSwitch('disabled');
									
                                    control.bootstrapSwitch('disabled', false);
                                    control.bootstrapSwitch('state', selectBool);
                                    control.bootstrapSwitch('disabled', currentBsSwitch);
                                } else {
                                    var currentCtrl = control.prop('disabled');
                                    control.prop('disabled', false);
                                    control.attr('checked', selectBool);
                                    control.prop('disabled', currentCtrl);
                                }
                            } else {
                                var currentDisabled = control.prop('disabled');
                                control.prop('disabled', false);
                                control.val(val);
                                control.prop('disabled', currentDisabled);
                            }
                        } else if (tag == 'SELECT') {
                            $.sectionproperties.selectGenerator(key, source, val, 0);
                        }
                    });
                }
            }
        }
    };
})(jQuery);

/*For common json data*/
/*Bind json data to form with same id-key*/
(function ($) {
    $.fn.BindToForm = function (fieldData, prefix, suffix) {

        var key = [],
            ctl = null,
            isTextField = false,
            fill = "";
        for (key in fieldData) {
            if (fieldData.hasOwnProperty(key)) {
                ctl = $(prefix + key + suffix, this);
                fill = fieldData[key];
                if (ctl.length != 0 ) {
                    $(ctl).each(function () {

                        var control = $(this);
                        var tag = control[0].tagName;
                        var type = control.prop('type');
                        var parentClass = control[0].parentNode.className;

                        var val = fill;
                        var source = fill != null ? fill.Source : null;
                        var isSet = fill != null ? fill.IsSet: "false";

                        var boolVal = val == "1" || val == "true" || val == true || val == "PDF";
                        var isSetBoolVal = isSet == "1" || isSet == "true" || isSet == true;

                        isTextField = (control.is("DIV") || control.is("SPAN") || control.is("LABEL"));

                        if (control.hasClass("userSelection") && val.length > 0) {
                            control.tagsinput({
                                itemValue: 'id',  /* this will be used to set id of tag*/
                                itemText: 'label', /* this will be used to set text of tag*/
                            });

                            if (val.lastIndexOf(';') == val.length - 1) {
                                val = val.substring(0, val.lastIndexOf(';'));
                            }
                            var selectedItem = val.split(';');

                            /*if the source is null or empty*/
                            source = source == null || source.length == 0 ? val : source;

                            var selectedSource = source.split(';');

                            control.tagsinput('removeAll');
                            $.each(selectedItem, function (index, obj) {
                                control.tagsinput('add', { id: obj, label: selectedSource[index] });
                            });
                        }
                        else if (isTextField) {
                            var current = control.prop('disabled');
                            control.prop('disabled', false);
                            control.text(val);
                            control.prop('disabled', current);

                        } else if (tag == 'INPUT') {

                            if (type == 'checkbox') {

                                var selectBool = suffix == "_IsSet" ? isSetBoolVal : boolVal;

                                if (parentClass == "bootstrap-switch-container") {
                                    var current = control.bootstrapSwitch('disabled');

                                    control.bootstrapSwitch('disabled', false);
                                    control.bootstrapSwitch('state', selectBool);
                                    control.bootstrapSwitch('disabled', current);
                                } else {
                                    var current = control.prop('disabled');
                                    control.prop('disabled', false);
                                    control.attr('checked', selectBool);
                                    control.prop('disabled', current);
                                }
                            } else {
                                var current = control.prop('disabled');
                                control.prop('disabled', false);
                                control.val(val);
                                control.prop('disabled', current);
                            }
                        } else if (tag == 'SELECT') {
                            $.sectionproperties.selectGenerator(key, source, val, 0);
                        } else if (tag == 'TEXTAREA') {
                            control.val(val);
                        }
                    });
                }
            }
        }
    };
})(jQuery);

/*Create generic model for a form*/
(function ($) {
    $.fn.MapFormData = function (e) {

        formObj = [];

        var input = $('input[type="text"], input[type="password"], input[type="hidden"], textarea', this);
        input.each(function () {
            var id = $(this)[0].id;
            var name = $(this)[0].name;
            var value = $(this)[0].value;
            var htmlTag = $(this)[0].tagName;

            var obj = { "Id": id, "Name": name, "Value": value, "Tag": htmlTag };
            formObj.push(obj);
        });

        var checkbox = $('input[type="checkbox"]', this);
        checkbox.each(function () {
            var id = $(this)[0].id;
            var name = $(this)[0].name;
            var value = $(this)[0].checked;
            var htmlTag = $(this)[0].tagName;

            var parentClass = $(this)[0].parentNode.className;
            var specialSwitch = $(this)[0].parentNode.closest(".switchSpecial");
            if (parentClass == 'bootstrap-switch-container' && specialSwitch) {

                var bootstrapVal = "";

                if (value) {
                    bootstrapVal = $(this)[0].dataset.onText;
                } else {
                    bootstrapVal = $(this)[0].dataset.offText;
                }

                value = bootstrapVal;
            }
            else {
                value = $(this).prop('checked');
            }

            var obj = { "Id": id, "Name": name, "Value": value, "Tag": htmlTag };
            formObj.push(obj);
        });

        var select = $('select', this);
        select.each(function () {
            var id = $(this)[0].id;
            var name = $(this)[0].name;
            var value = $(this)[0].value;
            var htmlTag = $(this)[0].tagName;

            var obj = { "Id": id, "Name": name, "Value": value, "Tag": htmlTag };
            formObj.push(obj);
        });

        return formObj;
    };
})(jQuery);

/* Handle Invalid Page */
(function ($) {
    $invalid = {
        renderPage: function (errormsg, title) {

            fxcRequest.get("/Common/InvalidPage",
                { errormsg },
                function (data) {
                    $(".preloader").fadeOut();

                    $('html body .dtp.hidden').remove();
                    $('html body .gj-list.gj-list-bootstrap.gj-dropdown-list-bootstrap.list-group').remove();
                    $('div.fxc-main-content-body').css({ opacity: '0.0' }).html(data).delay(50).animate({ opacity: '1.0' }, 300);
                    /*$(".fix-header .topbar").stick_in_parent({});*/

                    if (title || title !== '') { /* user panel */
                        $('#breadcrumbs').empty();
                        $('#breadcrumbs').append('<div class="col-sm-5 col-12 align-self-center order-sm-1 order-2"> <ol class="breadcrumb UserHeader"> <li class="breadcrumb-item active"> <span class="icon"><i class="mdi mdi-folder-multiple-outline"></i></span> <span class="title1">' +
                            '' + title + '</span > <span class="badge badgeDisplay displayTotal1">0</span> </li ></ol > </div > <div class="col-sm-7 col-12 align-self-center order-sm-2 order-1"> </div>');
                    } else { /* admin panel */
                        $('#breadcrumbs').children().last().hide();
                    }

                    if (!$('#breadcrumbs').hasClass("page-titles")) {
                        $('#breadcrumbs').addClass("page-titles");
                        $('#breadcrumbs').addClass("row");
                    }
                }
                , null);
        }
    };
})(window.jQuery);


(function ($) {
    var self;
    
    $.layoutLanguages = {
        initLanguage: function (opts) {
            self = this;
            self.opts = opts;
            self.currentItem = '';
            self.getLanguages();
            self.initDocClick();
        },
        initDocClick: function () {
            $(document).click(function (e) {
                if ($(e.target).hasClass('languageColapsible')) {
                    var myDropdown = document.getElementById('accountDetailsBtn');
                    myDropdown.click();
                }
            });
        },
        getLanguages: function () {
            fxcRequest.get('/Common/GetLanguages',
                {},
                function (data) {
                    if (data && data.XmlItems && data.XmlItems.Items) {
                        $.each(data.XmlItems.Items, function (i, item) {
                            var languageItem = $('<li>');
                            var languageItemLink = $('<a class="language-item" data-lang="' + item.Value + '" aria-label="' + item.Text + '">' + item.Text + '</a>');

                            if (item.Value === self.opts.language) {
                                $(languageItemLink).addClass('active');
                                self.currentItem = languageItemLink;
                            }

                            languageItem.append(languageItemLink);
                            $('#language-selector').append(languageItem);
                        });

                        self.languageItemClickHandler('.language-item');
                    }
                }, null);
        },
        setLanguage: function (language) {
            $.each($('#language-selector li a'), function (i, item) {
                var languageValue = $(item).data('lang');
                if (language === languageValue) self.setActiveLanguage(this);
            });
        },
        languageItemClickHandler: function (e) {
            $(e).click(function () {
                if (!$(this).hasClass('active')) {
                    var languageValue = $(this).data('lang');

                    self.setActiveLanguage(this);
                    self.updateLanguage(languageValue);
                }
            });
        },
        setActiveLanguage: function (item) {
            if (self.currentItem.length > 0)
                self.currentItem.removeClass('active');

            $(item).addClass('active');
            self.currentItem = $(item);
        },
        updateLanguage: function (language) {
            console.log(language);
            fxcRequest.post('/Common/UpdateUserConfig',
                {
                    'ConfigName': self.opts.config,
                    'ConfigValue': language
                },
                function (data) {
                    fxcUserConn.onUpdateUser($('#FxcUserId').val(), true, true);
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSave, "error");
                });
        }
    };
})(window.jQuery);