﻿var treeview = treeview || {};
var obj = obj || {};


treeview.init = function (treeid, targetName, targetID, obj) {
	var $treeview;
	obj = obj || {};
	var jsonNode = [];

	/* Configuration */
	var check = obj.check || false; /*Check dtree node.*/

	/* Run either one */
	var expandAll = obj.expandAll || false; /* Expand all tree nodes */
	var collapseAll = obj.collapseAll || false; /* Collapse all tree nodes */
	var expandLevel = obj.expandLevel || null; /* Set to expand till what level eg: null, 1, 2, 3 */
	var expandNodeValue = obj.expandNodeValue || null; /* Set to expand which node array on load eg: null or [1, 2, 4]; */
	var expandNodeCascading = obj.expandNodeCascading || false; /* 	{boolean} Expand all children */
	var selectFirstNode = obj.selectFirstNode || false; /* enable default selection on first node  */
	/* End Run either one */

	var selectionType = obj.selectionType || "single";  /*Single or Multiple */
	var lazyLoading = obj.lazyLoading || false; /* Initialization of an object until the point at which it is needed */
	var dataSource = obj.dataSource || "/Common/ConfigureDomain/";

	/* Function */
	var reselectChild = obj.reselectChild || false; /* IF the parent is disabled, on select parent --> push to select first child node */

	var postSelectFn = obj.postSelectFn || null;
	var declareType = obj.declareType || null;  /* IF declare type = textbox, triggered on click show treeview */
	var cascadeSelection = obj.cascadeSelection || false; /*This setting enable cascade selection and unselection of children*/

	/*exchange*/
	var dummyNodeId = "dummynode";
	var loadingTemplate = '<div id="LoadingBar" data-role="wrapper"><span data-role="spacer" style="width: 24px;"></span><span data-role="display"><img style="margin-left:50px;" height="35" width="35" src="/Content/img/ajax-loading2.gif"/></span></div>';

	$treeview = $("#" + treeid).tree({
		primaryKey: 'id',
		dataSource: dataSource,
		checkboxes: check,
		uiLibrary: 'bootstrap4',
		icons: {
			collapse: '<i class="mdi mdi-chevron-down"></i>',
			expand: '<i class="mdi mdi-chevron-right"></i>'
		},
		selectionType: selectionType,
		cascadeSelection: cascadeSelection
	});

	$treeview.on('nodeDataBound', function (e, node, id, record) {
		var arr = {};
		arr['node'] = node;
		arr['record'] = record;
        jsonNode.push(arr);

        if ($(node[0]).children("div").children('[data-role="spacer"]').length > 0) {
            var getWidth = parseInt($(node[0]).find('[data-role="spacer"]').width());
			$(node[0]).children("div").children('[data-role="spacer"]').css("min-width", getWidth);

			$(node[0]).attr("title", record.text);
        }
	});

	$treeview.on('dataBound', function (e) {
        var myArr1 = JSON.parse($treeview.xhr.responseText);

		if (expandNodeValue !== null) {
			/*console.log(expandNodeValue.length);*/
			for (i = 0; i < myArr1.length; i++) {
				for (j = 0; j < expandNodeValue.length; j++) {
					if (i + 1 === expandNodeValue[j]) {
						var id = myArr1[i].id;
						var category = myArr1[i].category;
						var getObj = jsonNode.find(x => x.record.id === id && x.record.category === category);
						if (getObj === null) {
							$treeview.expand(getObj.node);
						}
					}
				}
			}
		}
		else if (expandLevel !== null) {
			for (x in myArr1) {
				/*console.log(myArr1[x]);*/
				var id2 = myArr1[x].id;
				var category2 = myArr1[x].category;
				var getObj2 = jsonNode.find(x => x.record.id === id2 && x.record.category === category2);
				if (getObj2 !== null) {
					$treeview.expand(getObj2.node);
				}
				var myArr2 = myArr1[x].children;
				Loop2:
				for (i = 1; i < expandLevel; i++) {
					if (myArr2 !== null && myArr2.length > 0) {
						for (y in myArr2) {
							var idChild = myArr2[y].id;
							var categoryChild = myArr2[y].category;
							var getObjChild = jsonNode.find(x => x.record.id === idChild && x.record.category === categoryChild);
							if (getObjChild !== null) {
								$treeview.expand(getObjChild.node);
							}

							i++;
							myArr2 = myArr2[y].children;
							continue Loop2;
						}
					}
				}
			}
		}
		else if (expandAll) {
			$treeview.expandAll();
		}
		else if (collapseAll) {
			$treeview.collapseAll();
		}
		if (selectFirstNode && myArr1.length > 0) {
			$.each(myArr1, function (key, value) {
				
				var checkID = myArr1[key].id;
				var checkCategory = myArr1[key].category;

				var checkObj = jsonNode.find(x => x.record.id === checkID && x.record.category === checkCategory);
				var checkNode = checkObj.node;
				var checkParamObj = checkNode["0"].dataset;
				
				/*select 1st child if parent disable*/
				if (checkParamObj.disabled === "true") {
					if (reselectChild) {
						var children = $treeview.getChildren(checkNode);
						
						if (Array.isArray(children) && children.length && children[0] !== dummyNodeId) {
							$treeview.select(checkNode);
							return false;
						}
					}
				}
				else {
					$treeview.select(checkNode);
					return false;
				}
			});
		}
		else if (declareType === "textbox") {
			var id4 = $("#" + targetID).val();
			var node = $treeview.getNodeById(id4);
			if (node !== undefined) {
				$treeview.select(node);
			}
		}

		/*remove dummy nodes for exchange*/
		var dummy = $treeview.getNodeById(dummyNodeId);
		if (dummy !== null && dummy !== undefined) {
			$treeview.removeNode(dummy);
		}

		/* Added slim scroll bar 
		$treeview.each(function (e, index) {
			custom.setDropDownMenu($(this));
		}); */
    });

    $treeview.on('expand', function (e, node, id) {
        var extraParamObj = node["0"].dataset;
        /*Start load exchange AB*/
        var exchangeAB = $treeview.getChildren(node);
        if (extraParamObj.category === "5" && id === "9999" && exchangeAB.length === 0) {
            $(this).find('li[data-category="5"][data-id="9999"]:visible').append(loadingTemplate);
            fxcRequest.get('/user/addressbook/exchange', null,
                function (data) {
                    $('li[data-category="5"][data-id="9999"] #LoadingBar').remove();
					$.each(data, function (index, value) {
                        $treeview.addNode({ text: value.Name, id: value.Id, category: "5", disabledField: false }, node);
                    });
                });
        }
		/*End load exchange AB*/
    });

	$treeview.on('select', function (e, node, id) {
		if (node == null)
			return false;
		var extraParamObj = node["0"].dataset;
		/*select 1st child if parent disable*/
		if (extraParamObj.disabled === "true") {
			if (reselectChild) {
				var children = $treeview.getChildren(node);

				if (Array.isArray(children) && children.length && children[0] !== dummyNodeId) {
					/* array does not exist, is not an array, or is empty*/
					var selectedChildNode = $treeview.getNodeById(children[0]);
					$treeview.select(selectedChildNode);
					/* end Function immediatiately */
				}
			}
			$treeview.expand(node);
			return false;
		}

		var data = $treeview.getDataById(id);
		$("#" + targetName).val(data.text);
		$("#" + targetID).val(id);
		$("#" + treeid + "-ddl").val(data.text);

		if (postSelectFn !== null) {
			var requestObj = obj;
			postSelectFn.call(this, id, extraParamObj, requestObj);
		}

		if (declareType === "textbox" && $("#selectTreeView-" + treeid + " .TreeView").is(":focus")) {
			$("#selectTreeView-" + treeid + " .TreeView").blur();
		}
	});

	if ($('#search-treeview-' + treeid + '').length == 0) {
		$("div#" + treeid).prepend('<div class="search-treeview"><input data-tree="' + treeid + '" id="search-treeview-' + treeid + '" type="text" placeholder="Search" aria-label="Search" class="form-control search-treeview-input"/></div>');
    }

	$('input#search-treeview-' + treeid + '').on('input', function (e) {
		treeview.search($treeview, this.value);
	}).on('keypress', function (e) {
		if (e.which === 13) {
			treeview.search($treeview, this.value);
			e.preventDefault();
			return false;
		}
	});

	if (!$("#selectTreeView-" + treeid + " .TreeView").hasClass("TreeView-show")) {
		$("#selectTreeView-" + treeid + " .TreeView").addClass("TreeView-show");
	}

	if (declareType === "textbox") {
		$("#selectTreeView-" + treeid + " .TreeView").removeClass("TreeView-show");
		$("#selectTreeView-" + treeid + " input.selectTreeView-textbox").focus(function (e) {
			$("#selectTreeView-" + treeid + " .TreeView").addClass("TreeView-show");
			$("#selectTreeView-" + treeid + " .TreeView").focus();
			$("#" + treeid + " > ul").scrollTop(0);
			if ($("#" + treeid + " li[data-role=\"node\"].active").length > 0) {

				var firstElement = $("#" + treeid + " li[data-role=\"node\"].active").offset().top;
				var ulPos = $("#" + treeid + " ul").offset().top;

				$("#" + treeid + " > ul").scrollTop(firstElement - ulPos);
            }
		});

		$("#selectTreeView-" + treeid + " .TreeView").blur(function (e) {
			setTimeout(() => {
				if (!document.getElementById(treeid).contains(document.activeElement)) {
					$("#" + treeid + " > ul").scrollTop(0);
					$("#selectTreeView-" + treeid + " .TreeView").removeClass("TreeView-show");
					$('input#search-treeview-' + treeid + '').val("").trigger("input");
				}
			});
		});
		$("#selectTreeView-" + treeid + " .TreeView .search-treeview-input").blur(function (e) {
			setTimeout(() => {
				if (!document.getElementById(treeid).contains(document.activeElement)) {
					$("#" + treeid + " > ul").scrollTop(0);
					$("#selectTreeView-" + treeid + " .TreeView").removeClass("TreeView-show");
					$('input#search-treeview-' + treeid + '').val("").trigger("input");
				}
			});
		});
	}
	else if (declareType === "button") {
		$(".dropdown:not(.show) #" + treeid + "Btn").on("click", function (e) {
			$('#' + treeid).tree().unselectAll();
		});
		$("."+ treeid +"Div div.dropdown-menu .selectTreeView").on("click", function (e) {
			e.stopPropagation();
		});
	}
	$treeview.reload();

	return $treeview;
};

treeview.selectNode = function ($treeview, value) {
	if ($treeview == null)
		return false;
	$treeview.unselectAll();
	var node = $treeview.getNodeById(value);
	if (node !== undefined) {
		$treeview.select(node);
	}
	else {
		var dashboardId = $('#dashboardID').val();
		var dashboardNode = $treeview.getNodeById(dashboardId);
		if (dashboardNode !== undefined) {
			$treeview.select(dashboardNode);
		}
	}
};

/*
 * @tree = treeview 
 * @treeMobile = mobile treeview
 * @isAddBook = isAddBook [boolean]
 * 
 * To map the expand/collapse state of two treeviews if they are related to each other
 */
treeview.mapState = function ($treeview, $treeviewMobile, isAddBook = false) {
    var mobileExpand = false;
    var mobileCollapse = false;
    var desktopExpand = false;
    var desktopCollapse = false;

    /* Some address book's main folders have the same data-id
     * (eg: both My Address Books & Domain Address Books have id = 9999) 
     * Hence, use getNodeByText instead
     */

    $treeview.on('expand', function (e, node, id) {
        if (!mobileExpand) {
            var getSelectedNode = isAddBook ? $treeviewMobile.getNodeByText(node.data("text")) : $treeviewMobile.getNodeById(id);

            if (getSelectedNode != null) {
                desktopExpand = true;
                $treeviewMobile.expand(getSelectedNode);
            }
        }
        mobileExpand = false;
    });

    $treeviewMobile.on('expand', function (e, node, id) {
        if (!desktopExpand) {
            var getSelectedNode = isAddBook ? $treeview.getNodeByText(node.data("text")) : $treeview.getNodeById(id);

            if (getSelectedNode != null) {
                mobileExpand = true;
                $treeview.expand(getSelectedNode);
            }

        }
        desktopExpand = false;
    });

    $treeview.on('collapse', function (e, node, id) {
        if (!mobileCollapse) {
            var getSelectedNode = isAddBook ? $treeviewMobile.getNodeByText(node.data("text")) : $treeviewMobile.getNodeById(id);

            if (getSelectedNode != null) {
                desktopCollapse = true;
                $treeviewMobile.collapse(getSelectedNode);
            }
        }
        mobileCollapse = false;
    });

    $treeviewMobile.on('collapse', function (e, node, id) {
        if (!desktopCollapse) {
            var getSelectedNode = isAddBook ? $treeview.getNodeByText(node.data("text")) : $treeview.getNodeById(id);

            if (getSelectedNode != null) {
                mobileCollapse = true;
                $treeview.collapse(getSelectedNode);
            }

        }
        desktopCollapse = false;
    });
};

treeview.search = function ($treeview, text) {
	if ($treeview == null)
		return false;
	var treeId = $treeview[0].getAttribute("id");

	$("#" + treeId + " li[data-role=\"node\"]").removeClass("searched search-item");
	$("#" + treeId + "[data-type=\"tree\"]").removeClass("searched");

	var getSearchText = text.toLowerCase();

	if (getSearchText.length > 0) {
		$("#" + treeId + "[data-type=\"tree\"]").addClass("searched");

		var searchNodes = $("#" + treeId + " li[data-role=\"node\"][data-search*=\"" + getSearchText + "\"]");

		if (searchNodes.length > 0) {
			$("#" + treeId + " > ul").scrollTop(0);
			searchNodes.addClass("searched search-item");
			searchNodes.parents("li[data-role=\"node\"]").addClass("searched");
			searchNodes.find("li[data-role=\"node\"]").addClass("searched");

			var firstElement = $("#" + treeId + " li[data-role=\"node\"].search-item")[0].offsetTop;
			$("#" + treeId + " > ul").scrollTop(firstElement);
		}
	}
};