/**
 * @license jquery.panzoom.js v3.2.2
 * Updated: Wed May 08 2019
 * Add pan and zoom functionality to any element
 * Copyright (c) timmy willison
 * Released under the MIT license
 * https://github.com/timmywil/jquery.panzoom/blob/master/MIT-License.txt
 */
(function(n,t){typeof define=="function"&&define.amd?define(["jquery"],function(i){return t(n,i)}):typeof exports=="object"?t(n,require("jquery")):t(n,n.jQuery)})(typeof window!="undefined"?window:this,function(n,t){"use strict";function w(n,t){for(var i=n.length;--i;)if(Math.round(+n[i])!==Math.round(+t[i]))return!1;return!0}function c(n){var i={range:!0,animate:!0};return typeof n=="boolean"?i.animate=n:t.extend(i,n),i}function r(n,i,r,u,f,e,o,s,h){this.elements=t.type(n)==="array"?[+n[0],+n[2],+n[4],+n[1],+n[3],+n[5],0,0,1]:[n,i,r,u,f,e,o||0,s||0,h||1]}function s(n,t,i){this.elements=[n,t,i]}function i(n,r){var u,f,s,h;if(!(this instanceof i))return new i(n,r);if(n.nodeType!==1&&t.error("Panzoom called on non-Element node"),t.contains(e,n)||t.error("Panzoom element must be attached to the document"),u=t.data(n,o),u)return u;this.options=r=t.extend({},i.defaults,r);this.elem=n;f=this.$elem=t(n);this.$set=r.$set&&r.$set.length?r.$set:f;this.$doc=t(n.ownerDocument||e);this.$parent=f.parent();this.parent=this.$parent[0];this.isSVG=p.test(n.namespaceURI)&&n.nodeName.toLowerCase()!=="svg";this.panning=!1;this._buildTransform();this._transform=t.cssProps.transform?t.cssProps.transform.replace(y,"-$1").toLowerCase():"transform";this._buildTransition();this.resetDimensions();s=t();h=this;t.each(["$zoomIn","$zoomOut","$zoomRange","$reset"],function(n,t){h[t]=r[t]||s});this.enable();this.scale=this.getMatrix()[0];this._checkPanWhenZoomed();t.data(n,o,this)}var e=n.document,o="__pz__",l=Array.prototype.slice,a=/trident\/7./i,v=function(){if(a.test(navigator.userAgent))return!1;var n=e.createElement("input");return n.setAttribute("oninput","return"),typeof n.oninput=="function"}(),y=/([A-Z])/g,p=/^http:[\w\.\/]+svg$/,u="(\\-?\\d[\\d\\.e-]*)",f="\\,?\\s*",h=new RegExp("^matrix\\("+u+f+u+f+u+f+u+f+u+f+u+"\\)$");return r.prototype={x:function(n){var u=n instanceof s,i=this.elements,t=n.elements;return u&&t.length===3?new s(i[0]*t[0]+i[1]*t[1]+i[2]*t[2],i[3]*t[0]+i[4]*t[1]+i[5]*t[2],i[6]*t[0]+i[7]*t[1]+i[8]*t[2]):t.length===i.length?new r(i[0]*t[0]+i[1]*t[3]+i[2]*t[6],i[0]*t[1]+i[1]*t[4]+i[2]*t[7],i[0]*t[2]+i[1]*t[5]+i[2]*t[8],i[3]*t[0]+i[4]*t[3]+i[5]*t[6],i[3]*t[1]+i[4]*t[4]+i[5]*t[7],i[3]*t[2]+i[4]*t[5]+i[5]*t[8],i[6]*t[0]+i[7]*t[3]+i[8]*t[6],i[6]*t[1]+i[7]*t[4]+i[8]*t[7],i[6]*t[2]+i[7]*t[5]+i[8]*t[8]):!1},inverse:function(){var t=1/this.determinant(),n=this.elements;return new r(t*(n[8]*n[4]-n[7]*n[5]),t*-(n[8]*n[1]-n[7]*n[2]),t*(n[5]*n[1]-n[4]*n[2]),t*-(n[8]*n[3]-n[6]*n[5]),t*(n[8]*n[0]-n[6]*n[2]),t*-(n[5]*n[0]-n[3]*n[2]),t*(n[7]*n[3]-n[6]*n[4]),t*-(n[7]*n[0]-n[6]*n[1]),t*(n[4]*n[0]-n[3]*n[1]))},determinant:function(){var n=this.elements;return n[0]*(n[8]*n[4]-n[7]*n[5])-n[3]*(n[8]*n[1]-n[7]*n[2])+n[6]*(n[5]*n[1]-n[4]*n[2])}},s.prototype.e=r.prototype.e=function(n){return this.elements[n]},i.rmatrix=h,i.defaults={eventNamespace:".panzoom",transition:!0,cursor:"move",disablePan:!1,disableZoom:!1,disableXAxis:!1,disableYAxis:!1,which:1,increment:.3,linearZoom:!1,panOnlyWhenZoomed:!1,minScale:.3,maxScale:6,rangeStep:.05,duration:200,easing:"ease-in-out",contain:!1},i.prototype={constructor:i,instance:function(){return this},enable:function(){this._initStyle();this._bind();this.disabled=!1},disable:function(){this.disabled=!0;this._resetStyle();this._unbind()},isDisabled:function(){return this.disabled},destroy:function(){this.disable();t.removeData(this.elem,o)},resetDimensions:function(){this.container=this.parent.getBoundingClientRect();var n=this.elem,r=n.getBoundingClientRect(),i=Math.abs(this.scale);this.dimensions={width:r.width,height:r.height,left:t.css(n,"left",!0)||0,top:t.css(n,"top",!0)||0,border:{top:t.css(n,"borderTopWidth",!0)*i||0,bottom:t.css(n,"borderBottomWidth",!0)*i||0,left:t.css(n,"borderLeftWidth",!0)*i||0,right:t.css(n,"borderRightWidth",!0)*i||0},margin:{top:t.css(n,"marginTop",!0)*i||0,left:t.css(n,"marginLeft",!0)*i||0}}},reset:function(n){n=c(n);var t=this.setMatrix(this._origTransform,n);n.silent||this._trigger("reset",t)},resetZoom:function(n){n=c(n);var t=this.getMatrix(this._origTransform);n.dValue=t[3];this.zoom(t[0],n)},resetPan:function(n){var t=this.getMatrix(this._origTransform);this.pan(t[4],t[5],c(n))},setTransform:function(n){for(var i=this.$set,r=i.length;r--;)t.style(i[r],"transform",n),this.isSVG&&i[r].setAttribute("transform",n)},getTransform:function(n){var r=this.$set,i=r[0];return n?this.setTransform(n):(n=t.style(i,"transform"),this.isSVG&&(!n||n==="none")&&(n=t.attr(i,"transform")||"none")),n==="none"||h.test(n)||this.setTransform(n=t.css(i,"transform")),n||"none"},getMatrix:function(n){var t=h.exec(n||this.getTransform());return t&&t.shift(),t||[1,0,0,1,0,0]},getScale:function(n){return Math.sqrt(Math.pow(n[0],2)+Math.pow(n[1],2))},setMatrix:function(n,i){var f,u,r,v,y,p;if(!this.disabled){if(i||(i={}),typeof n=="string"&&(n=this.getMatrix(n)),f=this.getScale(n),u=typeof i.contain!="undefined"?i.contain:this.options.contain,u){r=i.dims;r||(this.resetDimensions(),r=this.dimensions);var e,o,h,w=this.container,s=r.width,c=r.height,l=w.width,a=w.height,b=l/s,k=a/c;this.$parent.css("textAlign")!=="center"||t.css(this.elem,"display")!=="inline"?(h=(s-this.elem.offsetWidth)/2,e=h-r.border.left,o=s-l-h+r.border.right):e=o=(s-l)/2;v=(c-a)/2+r.border.top;y=(c-a)/2-r.border.top-r.border.bottom;n[4]=u==="invert"||u==="automatic"&&b<1.01?Math.max(Math.min(n[4],e-r.border.left),-o):Math.min(Math.max(n[4],e),-o);n[5]=u==="invert"||u==="automatic"&&k<1.01?Math.max(Math.min(n[5],v-r.border.top),-y):Math.min(Math.max(n[5],v),-y)}return i.animate!=="skip"&&this.transition(!i.animate),i.range&&this.$zoomRange.val(f),(this.options.disableXAxis||this.options.disableYAxis)&&(p=this.getMatrix(),this.options.disableXAxis&&(n[4]=p[4]),this.options.disableYAxis&&(n[5]=p[5])),this.setTransform("matrix("+n.join(",")+")"),this.scale=f,this._checkPanWhenZoomed(f),i.silent||this._trigger("change",n),n}},isPanning:function(){return this.panning},transition:function(n){if(this._transition)for(var u=n||!this.options.transition?"none":this._transition,i=this.$set,r=i.length;r--;)t.style(i[r],"transition")!==u&&t.style(i[r],"transition",u)},pan:function(n,t,i){if(!this.options.disablePan){i||(i={});var r=i.matrix;r||(r=this.getMatrix());i.relative&&(n+=+r[4],t+=+r[5]);r[4]=n;r[5]=t;this.setMatrix(r,i);i.silent||this._trigger("pan",r[4],r[5])}},zoom:function(n,i){var u,h,c;if(typeof n=="object"?(i=n,n=null):i||(i={}),u=t.extend({},this.options,i),!u.disableZoom){var y=!1,f=u.matrix||this.getMatrix(),o=new r(f),e=this.getScale(f);if(typeof n!="number"?(n=u.linearZoom?1+u.increment*(n?-1:1)/e:n?1/(1+u.increment):1+u.increment,y=!0):n=1/e,n=Math.max(Math.min(n,u.maxScale/e),u.minScale/e),h=o.x(new r(n,0,0,0,typeof u.dValue=="number"?u.dValue/e:n,0)),c=u.focal,c&&!u.disablePan){this.resetDimensions();var p=u.dims=this.dimensions,a=c.clientX,v=c.clientY;this.isSVG||(a-=p.width/e/2,v-=p.height/e/2);var l=new s(a,v,1),w=this.parentOffset||this.$parent.offset(),b=new r(1,0,w.left-this.$doc.scrollLeft(),0,1,w.top-this.$doc.scrollTop()),k=o.inverse().x(b.inverse().x(l));o=o.x(new r([n,0,0,n,0,0]));l=b.x(o.x(k));f[4]=+f[4]+(a-l.e(0));f[5]=+f[5]+(v-l.e(1))}f[0]=h.e(0);f[1]=h.e(3);f[2]=h.e(1);f[3]=h.e(4);this.setMatrix(f,{animate:typeof u.animate!="undefined"?u.animate:y,range:!u.noSetRange});u.silent||this._trigger("zoom",n,u)}},option:function(n,i){var r;if(!n)return t.extend({},this.options);if(typeof n=="string"){if(arguments.length===1)return this.options[n]!==undefined?this.options[n]:null;r={};r[n]=i}else r=n;this._setOptions(r)},_setOptions:function(n){t.each(n,t.proxy(function(n,i){switch(n){case"disablePan":this._resetStyle();case"$zoomIn":case"$zoomOut":case"$zoomRange":case"$reset":case"disableZoom":case"onStart":case"onChange":case"onZoom":case"onPan":case"onEnd":case"onReset":case"eventNamespace":this._unbind()}this.options[n]=i;switch(n){case"disablePan":this._initStyle();case"$zoomIn":case"$zoomOut":case"$zoomRange":case"$reset":this[n]=i;case"disableZoom":case"onStart":case"onChange":case"onZoom":case"onPan":case"onEnd":case"onReset":case"eventNamespace":this._bind();break;case"cursor":t.style(this.elem,"cursor",i);break;case"minScale":this.$zoomRange.attr("min",i);break;case"maxScale":this.$zoomRange.attr("max",i);break;case"rangeStep":this.$zoomRange.attr("step",i);break;case"startTransform":this._buildTransform();break;case"duration":case"easing":this._buildTransition();case"transition":this.transition();break;case"panOnlyWhenZoomed":this._checkPanWhenZoomed();break;case"$set":i instanceof t&&i.length&&(this.$set=i,this._initStyle(),this._buildTransform())}},this))},_checkPanWhenZoomed:function(n){var t=this.options,i;t.panOnlyWhenZoomed&&(n||(n=this.getMatrix()[0]),i=n<=t.minScale,t.disablePan!==i&&this.option("disablePan",i))},_initStyle:function(){var n={"transform-origin":this.isSVG?"0 0":"50% 50%"},i;this.options.disablePan||(n.cursor=this.options.cursor);this.$set.css(n);i=this.$parent;i.length&&!t.nodeName(this.parent,"body")&&(n={overflow:"hidden"},i.css("position")==="static"&&(n.position="relative"),i.css(n))},_resetStyle:function(){this.$elem.css({cursor:"",transition:""});this.$parent.css({overflow:"",position:""})},_bind:function(){var f=this,n=this.options,r=n.eventNamespace,c="mousedown"+r+" pointerdown"+r+" MSPointerDown"+r,a="touchstart"+r+" "+c,o="touchend"+r+" click"+r+" pointerup"+r+" MSPointerUp"+r,u={},l=this.$reset,e=this.$zoomRange,s,h;t.each(["Start","Change","Zoom","Pan","End","Reset"],function(){var i=n["on"+this];t.isFunction(i)&&(u["panzoom"+this.toLowerCase()+r]=i)});n.disablePan&&n.disableZoom||(u[a]=function(t){var i;(t.type==="touchstart"?!(i=t.touches||t.originalEvent.touches)||(i.length!==1||n.disablePan)&&i.length!==2:n.disablePan||(t.which||t.originalEvent.which)!==n.which)||(t.preventDefault(),t.stopPropagation(),f._startMove(t,i))},n.which===3&&(u.contextmenu=!1));this.$elem.on(u);if(l.length)l.on(o,function(n){n.preventDefault();f.reset()});if(e.length&&e.attr({step:n.rangeStep===i.defaults.rangeStep&&e.attr("step")||n.rangeStep,min:n.minScale,max:n.maxScale}).prop({value:this.getMatrix()[0]}),!n.disableZoom){if(s=this.$zoomIn,h=this.$zoomOut,s.length&&h.length){s.on(o,function(n){n.preventDefault();f.zoom()});h.on(o,function(n){n.preventDefault();f.zoom(!0)})}if(e.length){u={};u[c]=function(){f.transition(!0)};u[(v?"input":"change")+r]=function(){f.zoom(+this.value,{noSetRange:!0})};e.on(u)}}},_unbind:function(){this.$elem.add(this.$zoomIn).add(this.$zoomOut).add(this.$reset).off(this.options.eventNamespace)},_buildTransform:function(){return this._origTransform=this.getTransform(this.options.startTransform)},_buildTransition:function(){if(this._transform){var n=this.options;this._transition=this._transform+" "+n.duration+"ms "+n.easing}},_getDistance:function(n){var t=n[0],i=n[1];return Math.sqrt(Math.pow(Math.abs(i.clientX-t.clientX),2)+Math.pow(Math.abs(i.clientY-t.clientY),2))},_getMiddle:function(n){var t=n[0],i=n[1];return{clientX:(i.clientX-t.clientX)/2+t.clientX,clientY:(i.clientY-t.clientY)/2+t.clientY}},_trigger:function(n){typeof n=="string"&&(n="panzoom"+n);this.$elem.triggerHandler(n,[this].concat(l.call(arguments,1)))},_startMove:function(n,i){var b,nt;if(!this.panning){var f,o,l,k,h,s,a,v,r=this,d=this.options,c=d.eventNamespace,u=this.getMatrix(),y=u.slice(0),tt=+y[4],it=+y[5],g={matrix:u,animate:"skip"},p=n.type;p==="pointerdown"?(f="pointermove",o="pointerup"):p==="touchstart"?(f="touchmove",o="touchend"):p==="MSPointerDown"?(f="MSPointerMove",o="MSPointerUp"):(f="mousemove",o="mouseup");f+=c;o+=c;this.transition(!0);this.panning=!0;this._trigger("start",n,i);b=function(n,t){if(t){if(t.length===2){if(l!=null)return;l=r._getDistance(t);k=r.getScale(u);h=r._getMiddle(t);return}if(s!=null)return;(v=t[0])&&(s=v.pageX,a=v.pageY)}s==null&&(s=n.pageX,a=n.pageY)};b(n,i);nt=function(n){var t,f,e;if(n.preventDefault(),i=n.touches||n.originalEvent.touches,b(n,i),i){if(i.length===2){f=r._getMiddle(i);e=r._getDistance(i)-l;r.zoom(e*(d.increment/100)+k,{focal:f,matrix:u,animate:"skip"});r.pan(+u[4]+f.clientX-h.clientX,+u[5]+f.clientY-h.clientY,g);h=f;return}t=i[0]||{pageX:0,pageY:0}}t||(t=n);r.pan(tt+t.pageX-s,it+t.pageY-a,g)};t(e).off(c).on(f,nt).on(o,function(n){n.preventDefault();t(this).off(c);r.panning=!1;n.type="panzoomend";r._trigger(n,u,!w(u,y))})}}},t.Panzoom=i,t.fn.panzoom=function(n){var u,e,f,r;return typeof n=="string"?(r=[],e=l.call(arguments,1),this.each(function(){u=t.data(this,o);u?n.charAt(0)!=="_"&&typeof(f=u[n])=="function"&&(f=f.apply(u,e))!==undefined&&r.push(f):r.push(undefined)}),r.length?r.length===1?r[0]:r:this):this.each(function(){new i(this,n)})},i});