echo off

Rem,   get the fax software location.
for /f "tokens=2*" %%a in ('REG QUERY "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\FXC6.ServicesAPI" /v imagepath') do set "FCPATH=%%~b"
set FCPATH=%FCPATH:~0,-41%
echo Software installed at %FCPATH%

NET SESSION >nul 2>&1
if %ErrorLevel% NEQ 0 (
ECHO servicesrestart.bat MUSH be run as administrator
ECHO right click on the servicesrestart.bat and choose Run as Administrator
timeout 15
EXIT
)

REM Stop FaxCore Services

set svcname=FXC6.FaxAgent
set exename=FaxAgent.exe
CALL :StopSvc

set svcname=FXC6.DispatchAgent
set exename=DispatchAgent.exe
CALL :StopSvc

set svcname=FXC6.FileGateway
set exename=FileGatewayAgent.exe
CALL :StopSvc

set svcname=FXC6.RenderAgent
set exename=RenderAgent.exe
CALL :StopSvc

set svcname=FXC6.ReportAPI
set exename=FaxCore.Report.Api.exe
CALL :StopSvc 

set svcname=FXC6.SMTPGatewayAgent
set exename=SMTPGateway.exe
CALL :StopSvc

set svcname=FXC6.OpenAPI.Service
set exename=OpenAPI.exe
CALL :StopSvc

set svcname=FXC6.OpenAPI37.Service
set exename=OpenAPI37.exe
CALL :StopSvc

set svcname=FXC6.RFParser.Service
set exename=RFParser.Service
CALL :StopSvc

set svcname=FXC6.ServicesAPI
set exename=FaxCore.Internal.Api.exe
CALL :StopSvc 

set svcname=MSSQL$FXCDB
set exename=skip
CALL :StopSvc

rem stop all possible fax card services, some services will not exist and throw an error

set svcname=bostservice
set exename=bostservice
CALL :StopSvc
set "processName=bostsrv.exe"

tasklist | find /i "bostsrv.exe" >nul

if %errorlevel% equ 0 (
    taskkill /f /im "bostsrv.exe"
)

set svcname=EiconDivaLogService 
set exename=skip
CALL :StopSvc

set svcname=CASFax
set exename=CASFax.exe
CALL :StopSvc

set svcname=XCAPIService
set exename=xcapisvc.exe
CALL :StopSvc

set svcname=XCAPILineMonitor
set exename=XMonService.exe
CALL :StopSvc

echo[
REM Stop Windows IIS Server
ECHO Stopping Windows IIS Services

rem clean up rendering orphans (if they exist)
taskkill /f /im "FaxAgent.exe"  >nul 2>&1
taskkill /f /im "DispatchAgent" >nul 2>&1
taskkill /f /im "PrintDisp.exe" >nul 2>&1
taskkill /f /im "PrintCtrl.exe" >nul 2>&1
taskkill /f /im "pdf6.exe" >nul 2>&1
iisreset /stop

echo[
Echo Cleaning up logs in %FCPATH%
set LogName=%FCPATH%\web\log& CALL :CleanLogs
set LogName=%FCPATH%\web\adlog& CALL :CleanLogs
set LogName=%FCPATH%\svc.dispatcher\log& CALL :CleanLogs
set LogName=%FCPATH%\svc.faxagent\log& CALL :CleanLogs
set LogName=%FCPATH%\svc.filegateway\log& CALL :CleanLogs
set LogName=%FCPATH%\svc.internalapi\log& CALL :CleanLogs
set LogName=%FCPATH%\svc.renderagent\log& CALL :CleanLogs
set LogName=%FCPATH%\svc.report\log& CALL :CleanLogs
set LogName=%FCPATH%\svc.smtpgateway\log& CALL :CleanLogs
rem clean up the temp folder for rendering
rem clean up the temp folder for rendering
del "%FCPATH%\temp\*.tif" /Q >NUL  2>NUL
del "%FCPATH%\temp\*.pdf" /Q >NUL  2>NUL
del "%FCPATH%\temp\*.csv" /Q >NUL  2>NUL
echo[
REM Clean up old SQL Error Logs
ECHO Cleaning up any SQL error logs from local SQL server install.
rem SQL 2008
IF EXIST "C:\Program Files\Microsoft SQL Server\MSSQL11.FXCDB\MSSQL\Log" (
set LogName="C:\Program Files\Microsoft SQL Server\MSSQL11.FXCDB\MSSQL\Log\*.*" /Q 
)
rem SQL 2012
IF EXIST "C:\Program Files\Microsoft SQL Server\MSSQL11.FXCDB\MSSQL\Log" (
set LogName="C:\Program Files\Microsoft SQL Server\MSSQL11.FXCDB\MSSQL\Log\*.*" /Q 
)
IF EXIST "D:\Program Files\Microsoft SQL Server\MSSQL11.FXCDB\MSSQL\Log" (
set LogName="D:\Program Files\Microsoft SQL Server\MSSQL11.FXCDB\MSSQL\Log\*.*" /Q 
)
IF EXIST "C:\Program Files\Microsoft SQL Server\MSSQL15.FXCDB\MSSQL\Log" (
set LogName="C:\Program Files\Microsoft SQL Server\MSSQL15.FXCDB\MSSQL\Log\*.*"" /Q 
)
echo[
ECHO FaxCore server and associatied services have been stopped.
timeout 6
echo[
ECHO Restarting the FaxCore server and associatied services.

ECHO Startng Windows IIS Services.
iisreset /start
echo[
rem start the SQL DB
ECHO Starting locally installed SQL Server.
set svcname=MSSQL$FXCDB & CALL :StartSvc
timeout 6

rem for /L %%A in (1,1,2) do (
rem start faxcore services
echo[
ECHO Starting central FaxCore Services and Fax Board drivers.
set svcname=FXC6.ServicesAPI & CALL :StartSvc
set svcname=FXC6.DispatchAgent & CALL :StartSvc
set svcname=FXC6.FileGateway & CALL :StartSvc
set svcname=FXC6.RenderAgent & CALL :StartSvc
set svcname=FXC6.ReportAPI & CALL :StartSvc
set svcname=FXC6.SMTPGatewayAgent & CALL :StartSvc
set svcname=FXC6.OpenAPI37.Service & CALL :StartSvc
set svcname=EiconDivaLogService & CALL :StartSvc
set svcname=DiSip & CALL :StartSvc
set svcname=CASFax & CALL :StartSvc
set svcname=XCAPILineMonitor & CALL :StartSvc
set svcname=XCAPIService & CALL :StartSvc
set svcname=FXC6.RFParser.Service & CALL :StartSvc
set svcname=FXC6.FaxAgent & CALL :StartSvc

rem )

timeout 10
echo[
ECHO FaxCore server has been succesfully stopped and restarted.  Normal fax operations have resumed.
GOTO :EOF

:StopSVC

SC QUERY %svcname% >nul 2>&1
IF ERRORLEVEL 1060 GOTO NotInstalledStop

REM Check if service is set to automatic
for /f "tokens=3" %%a in ('sc qc %svcname% ^| find "START_TYPE"') do set starttype=%%a
if /i  "%starttype%"=="2" (
	REM services exists, so stop it
	rem ask the service to stop nicely
	Echo Stopping the service %svcname%
	SC STOP %svcname% >nul 2>&1  
	timeout 2 >nul 2>&1  
	REM now use a hammer, just because
	sc query "%svcname%" | find "STOPPED" >nul 2>&1 || (
		rem if %exename% neq "skip" taskkill /f /im %svcname% 
		if %exename% neq "skip" taskkill /f /im %exename%
	)
) ELSE (
    ECHO Service %svcname% is not set to automatic startup, skipping stop operation
    GOTO NotInstalledStop
)


:NotInstalledStop
EXIT /B


:StartSVC

SC QUERY %svcname% >nul 2>&1
IF ERRORLEVEL 1060 GOTO NotInstalledStart

REM Check if service is set to automatic
for /f "tokens=3" %%a in ('sc qc %svcname% ^| find "START_TYPE"') do set starttype=%%a
if /i  "%starttype%"=="2" (   
	REM services exists, so start it
	rem Echo Starting the service %svcname%
	net start %svcname% 
) ELSE (
    ECHO Service %svcname% is not set to automatic startup, skipping start operation
    ECHO.
    GOTO NotInstalledStart
)

:NotInstalledStart
EXIT /B

:CleanLogs
echo Cleaning logs in %LogName%

REM Ensure the log path exists
if not exist "%LogName%" (
    echo Directory %LogName% does not exist, skipping cleanup
    EXIT /B
)

REM Create Archive folder if it doesn't exist
set "ArchivePath=%LogName%\Archive"
if not exist "%ArchivePath%" (
    mkdir "%ArchivePath%" >nul 2>&1 || (
        echo Failed to create archive directory %ArchivePath%
        EXIT /B
    )
)

REM Delete files older than 8 days in Archive folder
forfiles /p "%ArchivePath%" /s /d -8 /c "cmd /c del /q @path" >nul 2>&1 

REM Move current logs to Archive (excluding Archive folder itself)
forfiles /p "%LogName%" /s /m *.* /c "cmd /c if @isdir==FALSE move @path "%ArchivePath%"" >nul 2>&1 || (
    echo Warning: Failed to move files to %ArchivePath%
)

REM Delete files older than 4 days in main log folder (excluding Archive folder)
forfiles /p "%LogName%" /s /m *.* /d -4 /c "cmd /c if @isdir==FALSE del /q @path" >nul 2>&1 

EXIT /B

:EOF